<?php
 
namespace App\Services;
 
use Carbon\Carbon;

use App\Models\Member;

use App\Models\CampaignDetail;
 
class AgencyRevenueService{

    public function calculateRevenueForRange(int $agencyId, ?string $startDate, ?string $endDate){

        $agency = Member::findOrFail($agencyId);
 
        $today = now();

        $start = $startDate ? Carbon::parse($startDate)->startOfDay() : $today->copy()->startOfMonth();

        $end = $endDate ? Carbon::parse($endDate)->endOfDay() : $today->copy()->endOfDay();
        // return $start;
        return CampaignDetail::whereHas('campaign', function ($q) use ($agency) {
                    $q->where('state_id', $agency->state);
                })
            ->whereBetween('call_date', [$start, $end])
            ->sum('sell_price');
    }

}

 