<?php

namespace App\Models\VendorData;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Vendor extends Model
{
    use HasFactory, SoftDeletes ;
    protected $table = 'vendors';
    protected $fillable = [
        
        'name',
        'billing_name',
        'group_name',
        'opening_balance',
        // 'print_group',
        // 'print_style',
        'last_year_closing',
        'short_name',
        'kind_atten',
        'address',
        'city',
        'district',
        'state',
        'pin_code',
        'email',
        'pan_no',
        'phone1',
        'phone2',
        'mobile',
        'fax',
        // 'depreciation',
        // 'profit_percent',
        // 'loss_percent',
        // 'duty_type',
        // 'gst_category',
        // 'bill_of_supply',
        // 'reg_sr_no',

        /*other details */

        'area_name', 
        'due_days',
        // 'bill_to_bill',
        'gst_no', 
        'udyam_no', 
        'msme_no',
        'tin_no', 
        'cst_no', 
        'tax_id_no', 
        'account_no', 
        'bank_name', 
        'ifsc_code',
        'cts_no', 
        'transport', 
        'destination', 
        'party_type',
        'lock_by',
        'days_limit', 
        'rs_limit', 
        'pf_on', 
        'pf_percent', 
        'agent_cd', 
        'vendor_cd',
        'tcs_limit', 
        'tcs_percent',


          // Export Details
        'country_name', 'credit_condition',
        'sea_loading', 'sea_discharge', 'sea_destination', 'sea_condition1',
        'road_loading', 'road_discharge', 'road_destination', 'road_condition1',
        'air_loading', 'air_discharge', 'air_destination', 'air_condition1',


    ];

    
    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }
	
}
