<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Schema;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'admins';

    protected $fillable = [
        'role_id',
        'name',
        'city',
        'state_id',
        'pancard',
        'aadharcard',
        'qualification',
        'address',
        'ifsc_code',
        'bank_name',
        'account_number',
        'mobile',
        'email',
        'password',
        'show_password',
        'aadhar_img',
        'pancard_img',
        'passbook_image',
        'selfi_image',
        'author_id',
        'status',
    ];

    protected $hidden = [
        'password',
        'show_password',
        'remember_token',
    ];

    protected $casts = [
        'created_at' => 'datetime:Y-m-d H:i:s',
        'updated_at' => 'datetime:Y-m-d H:i:s',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id');
    }

    public function citys()
    {
        return $this->belongsTo(City::class, 'city');
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'Active');
    }

    public function scopeOrderBySequence($query, string $order = 'asc')
    {
        $order = strtolower($order) === 'desc' ? 'desc' : 'asc';
        if (Schema::hasColumn($this->getTable(), 'sequence')) {
            return $query->orderByRaw('COALESCE(sequence, 9999999) ' . strtoupper($order));
        }
        return $query;
    }
}