<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Support\Facades\Schema;

class Team extends Model
{
    use HasFactory, SoftDeletes ,Sluggable;
    protected $table = 'teams';
    protected $fillable = [
        'name',
       'status',
       'sequence',
       'description',
       'designation',
       'image',
       'slug',
      

    ];

    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'active'); 
    }
    public function scopeOrderBySequence($query, string $order = 'asc')
    {
      
        $order = strtolower($order) === 'desc' ? 'desc' : 'asc';

       
        if (Schema::hasColumn('teams', 'sequence')) {
            return $query->orderByRaw('COALESCE(sequence, 9999999) ' . strtoupper($order));
        }
        return $query;
    }
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'name' 
            ]
        ];
    }
     
    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }

    protected $appends = ['image_url','image_thumb_url'];

	

    public function getImageUrlAttribute()
    {
        return array_key_exists('image', $this->attributes) && !empty($this->attributes['image']) 
            ? url('storage/' . $this->attributes['image']) 
            : null;
    }
    
    public function getImageThumbUrlAttribute()
    {
        return array_key_exists('image', $this->attributes) && !empty($this->attributes['image']) 
            ? url('storage/app/public/thumb/' . $this->attributes['image']) 
            : null;
    }
	
	


}
