<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Support\Facades\Schema;

class Subcategory extends Model
{
    use HasFactory, SoftDeletes ,Sluggable;
    protected $table = 'subcategories';
    protected $fillable = [
        'category_id',
        'name',
       'status',
       'image',
       'description',
       'sequence',
       'slug'

    ];

    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'active'); 
    }
    public function scopeOrderBySequence($query, string $order = 'asc')
    {
      
        $order = strtolower($order) === 'desc' ? 'desc' : 'asc';

       
        if (Schema::hasColumn('subcategories', 'sequence')) {
            return $query->orderByRaw('COALESCE(sequence, 9999999) ' . strtoupper($order));
        }
        return $query;
    }
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'name' 
            ]
        ];
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id'); 
    }
     
    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }
    protected $appends = ['image_url','image_thumb_url'];

	

    public function getImageUrlAttribute($value)

{

    return  !empty($this->attributes['image'])? asset('storage/'.$this->attributes['image']):null;

}
public function getImageThumbUrlAttribute($value)
{
    return !empty(url('storage/app/public/thumb/'.$this->attributes['image']))? url('storage/app/public/thumb/'.$this->attributes['image']):null;
}

}
