<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sitesetting extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'sitesettings';

    protected $fillable = [
        'comp_name',
        'web_title',
        'meta_keyword',
        'meta_description',
        'image',
        'profile_photo',           
        'fevicon',
        'comp_phone',
        'whatsapp_number',
        'comp_email',
        'comp_tweeter',
        'comp_fb',
        'insta_link',
        'linkdin_link',
        'youtube_title',
        'youtube_link',
        'comp_address',
        'voucher_no_prefix'
    ];

    protected $appends = [
        'image_url',
        'fevicon_url',
    ];

    public function getImageUrlAttribute()
    {
        return !empty($this->attributes['image']) ? asset($this->attributes['image']) : null;
    }

    public function getFeviconUrlAttribute()
    {
        return !empty($this->attributes['fevicon']) ? asset($this->attributes['fevicon']) : null;
    }

    public function getProfilePhotoUrlAttribute()
    {
        return !empty($this->attributes['profile_photo']) ? asset($this->attributes['profile_photo']) : null;
    }
}