<?php

namespace App\Models;

use App\Models\PurchaseData\PurchaseGroup;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RawMaterial extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'raw_materials';

    protected $primaryKey = 'id';

    protected $fillable = [
        'firm_id',
        'item_name',
        'short_name',
        'billing_name',
        'unit_name',
        'purchase_rate',
        'opening_rate',
        'cost_rate',
        'category_id',
        'purchase_group_id',
        'item_id',
        'bar_code',
        'inclusive_tax',
        'sgst',
        'cgst',
        'igst',
        'cess',
        'hsn_code',
        'maximum_qty',
        'minimum_qty',
        'reorder_level',
        'reorder_qty',
        'receipt_item',
        'rr_item',
    ];

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public function firm()
    {
        return $this->belongsTo(Firm::class, 'firm_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function purchaseGroup()
    {
        return $this->belongsTo(PurchaseGroup::class, 'purchase_group_id');
    }
}
