<?php

namespace App\Models\PurchaseData;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseOrderItem extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'purchase_order_items';

    protected $fillable = [
        'order_id',
        'p',
        'item_id',
        'item_name',
        'pack',
        'grn_no',
        'quantity',
        'net_rate',
        'discount',
        'amount',
        'tax_percent',
        'tax_amount',
        'cgst',
        'sgst',
        'igst',
        'cess',

    ];

    public function order()
    {
        return $this->belongsTo(PurchaseOrder::class, 'order_id', 'id');
    }

    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',

        ];
    }
}
