<?php

namespace App\Models\PurchaseData;

use App\Models\User;
use App\Models\VendorData\Vendor;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseOrder extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'purchase_orders';

    protected $fillable = [

        'user_id', 'vendor_id', 'party_name', 'gst_name', 'gst_no',

        'voucher_no_int',
        'voucher_no', 'voucher_date', 'party_ref_no', 'ref_date', 'po_no', 'po_date',
        'payment_dr_cr', 'invoice', 'gst_rcm_itc', 'rcm', 'total_discount', 'subtotal', 'tax_amount', 'grand_total', 'payable_amount',

        'total_cess', 'total_cgst', 'total_sgst', 'total_igst',

    ];

    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'vendor_id', 'id');
    }

    public function items()
    {
        return $this->hasMany(PurchaseOrderItem::class, 'order_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',

        ];
    }
}
