<?php

namespace App\Models\PurchaseData;

use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PurchaseGroup extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'purchase_groups';

    protected $fillable = [
        'category_id',
        'name',
        'slug',
        'status',
    ];

    protected $attributes = [
        'status' => 'Active',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }
}
