<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Support\Facades\Schema;

class PermissionType extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'permissiontypes';
    protected $fillable = [
        'name',
        'status',
    ];

    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'active'); 
    }

    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }

   
	


	
}
