<?php

namespace App\Models;

use App\Notifications\ResetPasswordNotification;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Schema;

class Member extends Authenticatable
{
    use HasFactory, Notifiable ,Sluggable,SoftDeletes;

    protected $table = 'members';

    protected $fillable = [
        'name',
        'status',
        'sequence',
        'slug',
        'city_id',
        'category_id',
        'sub_category',
        'member_referred_id',
        'admin_referred_id',
        'mobile',
        'email',
        'password',
        'pincode',
        'panno',
        'aadharno',
        'gst',
        'referBy',
        'businessProof',
        'selfie',
        'signature',
        'businessName',
        'state',
        'show_password',
        'commission',
        'accept_condition',
        'business_type',
        'bank_name',
        'bank_account_number',
        'bank_ifsc_code',
        'note',
    ];

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }

    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'active');
    }

    public function scopeOrderBySequence($query, string $order = 'asc')
    {

        $order = strtolower($order) === 'desc' ? 'desc' : 'asc';

        if (Schema::hasColumn('categories', 'sequence')) {
            return $query->orderByRaw('COALESCE(sequence, 9999999) '.strtoupper($order));
        }

        return $query;
    }

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'name',
            ],
        ];
    }

    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',

        ];
    }

    protected $appends = ['business_Proof_url', 'selfie_url', 'signature_url'];

    public function getBusinessProofUrlAttribute()
    {
        return array_key_exists('businessProof', $this->attributes) && ! empty($this->attributes['businessProof'])
            ? url('storage/'.$this->attributes['businessProof'])
            : null;
    }

    public function getSelfieUrlAttribute()
    {
        return array_key_exists('selfie', $this->attributes) && ! empty($this->attributes['selfie'])
            ? url('storage/'.$this->attributes['selfie'])
            : null;
    }

    public function getSignatureUrlAttribute()
    {
        return array_key_exists('signature', $this->attributes) && ! empty($this->attributes['signature'])
            ? url('storage/'.$this->attributes['signature'])
            : null;
    }

    public function city()
    {
        return $this->belongsTo(City::class, 'city_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state');
    }
}
