<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Support\Facades\Schema;

class Ledger extends Model
{
    use HasFactory, SoftDeletes ;
    protected $table = 'ledgers';
    protected $fillable = [
        'member_id',
        'campaign_id',
        'amount',
        'datee',
        'utr_no',
        'sequence',
        'status',
        'credit',
        'debit',
        'transaction_type',
        'run_type',
        'description',
        'bill_payment_id',
        'return_invoice_id',
        'created_at',
        'updated_at',
    ];
    
    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'active'); 
    }
    public function scopeOrderBySequence($query, string $order = 'asc')
    {
      
        $order = strtolower($order) === 'desc' ? 'desc' : 'asc';

       
        if (Schema::hasColumn('credit_limits', 'sequence')) {
            return $query->orderByRaw('COALESCE(sequence, 9999999) ' . strtoupper($order));
        }
        return $query;
    }

    public function member()
    {
        return $this->belongsTo(Member::class, 'member_id');
    }
   
     
    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }

   
	


}
