<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Support\Facades\Schema;

class Language extends Model
{
    use HasFactory, SoftDeletes ;
    protected $table = 'languages';
    protected $fillable = [
        'name',
        'status',
        'sequence',
    ];

    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'active'); 
    }
    public function scopeOrderBySequence($query, string $order = 'asc')
    {
      
        $order = strtolower($order) === 'desc' ? 'desc' : 'asc';

       
        if (Schema::hasColumn('cities', 'sequence')) {
            return $query->orderByRaw('COALESCE(sequence, 9999999) ' . strtoupper($order));
        }
        return $query;
    }
     
    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }

   
	
}
