<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Firm extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'firms';

    protected $fillable = [
        'firm_name', 'firm_type', 'registration_number', 'date_of_establishment', 'status',
        'owner_name', 'designation', 'email', 'mobile_number', 'alternate_mobile_number',
        'gst_number', 'pan_number', 'aadhar_number', 'tan_number', 'cin_number', 'msme_number',
        'address_line1', 'address_line2', 'city', 'district', 'state', 'country', 'pincode',
        'bank_name', 'branch_name', 'account_holder_name', 'account_number', 'ifsc_code', 'upi_id',
        'logo', 'pan_card_image', 'aadhar_card_image', 'gst_certificate', 'bank_passbook_image',
        'registration_certificate', 'website_url', 'facebook_url', 'instagram_url', 'linkedin_url',
        'remarks', 'created_by'
    ];

    protected $dates = ['date_of_establishment', 'deleted_at'];

    protected $attributeNames = [
        'firm_name'      => 'Firm Name',
        'owner_name'     => 'Owner Name',
        'email'          => 'Email',
        'mobile_number'  => 'Mobile Number',
        'gst_number'     => 'GST Number',
        'state'          => 'State',
        'city'           => 'City', 
        'address_line1'  => 'Address',
        'logo'           => 'Firm Logo',
        'status'         => 'Status',
    ];

    public function getAttributeNames()
    {
        return $this->attributeNames;
    }

    public function getValidationAttributes()
    {
        return $this->attributeNames;
    }

    public function stateInfo()
    {
        return $this->belongsTo(State::class, 'state');
    }
    
    public function cityInfo()
    {
        return $this->belongsTo(City::class, 'city');
    }

    public function scopeActive($query) { return $query->where('status', 1); }
    public function creator() { return $this->belongsTo(User::class, 'created_by'); }
}