<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Support\Facades\Schema;

class Category extends Model
{
    use HasFactory, SoftDeletes ,Sluggable;
    protected $table = 'categories';
    protected $fillable = [
        'name',
        'status',
        'slug',
    ];

    public function scopeActiveStatus($query)
    {
        return $query->where('status', 'active'); 
    }
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'name' 
            ]
        ];
    }
     
    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }
	
	
}
