<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BillPayment extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'bill_payment';
    protected $fillable = [
        'member_id',
        'campaign_id',
        'product_id',
        'ledger_id',
        'amount',
        'cgst',
        'sgst',
        'igst',
        'total_amount',
        'description',
        'minute',
        'date_time',
    ];
    public function member()
    {
        return $this->belongsTo(Member::class, 'member_id');
    }
}
