<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Notifications\ResetAdminPasswordNotification;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Admin extends Authenticatable
{
    use HasFactory, Notifiable, SoftDeletes;

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetAdminPasswordNotification($token));
    }

    protected $fillable = [
        'role_id', 'name', 'city', 'pancard', 'aadharcard', 'qualification', 'address',
        'aadhar_img', 'pancard_img', 'ifsc_code', 'bank_name', 'account_number',
        'passbook_image', 'mobile', 'email', 'password', 'show_password',
        'jobcity', 'jobtype', 'jobplace', 'lead_target', 'product_by',
        'language',  'stype',
        'tds',
        'allowance',
        'salary_date',
        'working_day',
        'salary_day_wise',
        'target_quantity',
        'commission_per_lead',
        'lead_complet_bounce',
        'working_hours',
        'minute_rate',
        'selfi_image',
        'state_id',
        'incentive',
        'next_increment_date',
        'last_increment_date',
        'increment_salary',
        'increment_target',
        'increment_by_percent',
        'eci_id',
        'pf',
        'author_id',
        'penalty',
        'note',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    public function role()
    {
        return $this->belongsTo(Role::class, 'role_id');
    }

    public function citys()
    {
        return $this->belongsTo(City::class, 'city');
    }

    public function jobcities()
    {
        return $this->hasMany(City::class, 'id')->whereIn('id', explode(',', $this->jobcity ?? ''));
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id');
    }

    public function product()
    {
        return $this->belongsTo(RawMaterial::class, 'product_by');
    }

    protected $appends = ['aadhar_image_url', 'pan_image_url', 'passbook_image_url'];

    public function getAadharImageUrlAttribute()
    {
        return array_key_exists('aadhar_img', $this->attributes) && ! empty($this->attributes['aadhar_img'])
            ? url($this->attributes['aadhar_img'])
            : null;
    }

    public function getJobcitiesNamesAttribute()
    {
        if (! $this->jobcity) {
            return '-';
        }
        $cityIds = explode(',', $this->jobcity);
        $cities = City::whereIn('id', $cityIds)->pluck('name')->toArray();

        return implode(', ', $cities);
    }

    public function getPanImageUrlAttribute()
    {
        return array_key_exists('pancard_img', $this->attributes) && ! empty($this->attributes['pancard_img'])
            ? url($this->attributes['pancard_img'])
            : null;
    }

    public function getPassbookImageUrlAttribute()
    {
        return array_key_exists('passbook_image', $this->attributes) && ! empty($this->attributes['passbook_image'])
            ? url($this->attributes['passbook_image'])
            : null;
    }

    public function getSelfiImageUrlAttribute()
    {
        return array_key_exists('selfi_image', $this->attributes) && ! empty($this->attributes['selfi_image'])
            ? url($this->attributes['selfi_image'])
            : null;
    }
}
