<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Support\Facades\Schema;

class About extends Model
{
    use HasFactory, SoftDeletes ;
    protected $table = 'abouts';
    protected $fillable = [
        'about1_title',
        'image1',
        'about_description1',
        'about2_title',
        'image2',
        'about_description2',
        'about3_title',
        'image3',
        'about_description3',
        'image',
        'main_title',
        'title1',
        'title2',
        'title3',
        'title4',
        'description1',
        'description2',
        'description3',
        'description4',
        'work_title1',
        'work_percent1',
        'work_title2',
        'work_percent2',
        'work_title3',
        'work_percent3',

    ];

   
     
    protected function casts(): array
    {
        return [
            'created_at' => 'datetime:Y-m-d H:i:s',
            'updated_at' => 'datetime:Y-m-d H:i:s',
            'deleted_at' => 'datetime:Y-m-d H:i:s',
            
        ];
    }

    protected $appends = ['image_url','image1_url','image2_url','image3_url'];

	

    public function getImageUrlAttribute()
    {
        return array_key_exists('image', $this->attributes) && !empty($this->attributes['image']) 
            ? url('storage/' . $this->attributes['image']) 
            : null;
    }

    public function getImage1UrlAttribute()
    {
        return array_key_exists('image1', $this->attributes) && !empty($this->attributes['image1']) 
            ? url('storage/' . $this->attributes['image1']) 
            : null;
    }
    public function getImage2UrlAttribute()
    {
        return array_key_exists('image2', $this->attributes) && !empty($this->attributes['image2']) 
            ? url('storage/' . $this->attributes['image2']) 
            : null;
    }
    public function getImage3UrlAttribute()
    {
        return array_key_exists('image3', $this->attributes) && !empty($this->attributes['image3']) 
            ? url('storage/' . $this->attributes['image3']) 
            : null;
    }
    
   
	
	
}
