<?php

namespace App\Mail\Member;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $emailDetails;

    public function __construct($emailDetails)
    {
        $this->emailDetails = $emailDetails;
    }
    public function build()
    {
        $subject = $this->emailDetails['subject'] ?? 'Singi Marketing';
        
        return $this->from('info@singimarketing.com', 'Singi Marketing')
                    ->subject($subject)
                    ->view('mail.member.welcome-mail')
                    ->with([
                        'title'     => $this->emailDetails['title'],
                        'name'     => $this->emailDetails['name'],
                        'email'    => $this->emailDetails['email'],
                        'status'   => $this->emailDetails['status'],
                        'loginUrl' => $this->emailDetails['loginUrl'] ?? null,
                    ]);
    }

    
}
