<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Models\CampaignDetail;
use App\Models\Sitesetting;
class IVRReportjob implements ShouldQueue
{
    use Queueable, Dispatchable;

    /**
     * Create a new job instance.
     */
    protected $campaign_detail_id;
    public function __construct($campaign_detail_id)
    {
        $this->campaign_detail_id = $campaign_detail_id;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        \Log::info('ivr job run');
        $campaign_detail = CampaignDetail::where('id', $this->campaign_detail_id)->first();
        $sitesetting = Sitesetting::first();
        $ch = curl_init("https://backend.pbx.bonvoice.com/get-autocall-log/".$campaign_detail->call_event_id."/");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Token ".$sitesetting->ivr_token,
        ]);
        $response = $mainResponse = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $response = json_decode($response, true);
        // dd($response);
        \Log::info($response);
        if($response['status'] == '1'){
            $firstCall = $response['data'][0];
            $campaign_detail->call_duration = $firstCall['CallDuration'];
            $campaign_detail->start_time = $firstCall['StartTime'];
            $campaign_detail->end_time = $firstCall['EndTime'];
            if($firstCall['Status'] == 'CANCEL'){
                $campaign_detail->call_status = 'No Answer';
            }else if($firstCall['Status'] == 'None'){
                $campaign_detail->call_status = 'Not Connected';
            }else{
                $campaign_detail->call_status = $firstCall['Status'];
            }
            if($firstCall['AgentStatus'] == 'BUSY'){
                $campaign_detail->telecaller_status = 'No Answer';
            }else{
                $campaign_detail->telecaller_status = $firstCall['AgentStatus'];
            }
            $campaign_detail->ivrcall_id = $firstCall['callID'];
            $campaign_detail->voice_record_url = $firstCall['ResourceURL'];
            $campaign_detail->call_response = $mainResponse;
            $campaign_detail->update();
        }
    }
}
