<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;


class RedirectIfAuthenticatedUser
{
   
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        if (strpos($request->getPathInfo(), '/') === 0) {
            if (!Auth::check()) {
                session()->put('url.intended', url()->full());
                return redirect()->route('home')->withSuccess('Please log in first to access this page.');
            }
        }
        return $next($request);

    }
}
