<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;


class RedirectIfAuthenticatedMember
{
   
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        // dd($request->all());
        if (strpos($request->getPathInfo(), '/member-portal') === 0) {
            if (!Auth::guard('member')->check()) {
                session()->put('url.intended', url()->full());
                return redirect()->route('member.login');
            }
           
        }
        return $next($request);

    }
}
