<?php
namespace App\Http\Controllers\UserAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\Member;
use App\Models\Admin;
use App\Models\Inquiry;
use App\Models\Database;
use App\Models\Sitesetting;
use Auth;
use Str;
Use DB;
use Illuminate\Support\Facades\Password;
use Illuminate\Auth\Events\PasswordReset;
use App\Services\UserMailService;

class UserController extends Controller
{

    public function userreqister(Request $request,UserMailService $userMailService)
    {
        $rule = [
            'name' => 'required|string|min:3|max:255',
            'businessName' => 'required|string|min:3|max:255',
            'mobile' => 'required|digits:10|unique:members,mobile',
            'email' => 'required|email|unique:members,email|max:255',
            'city_id' => 'required',
            'sub_category' => 'required',
            'businessProof' => 'required|mimes:jpeg,png,jpg,pdf|max:5120',
            'selfie'=> 'required|image|mimes:jpeg,png,jpg|max:5120',
            'signature'=> 'required|image|mimes:jpeg,png,jpg|max:5120',
            'password' => 'required|min:6',
            'confirm_password' => 'required|same:password',
            'pincode' => 'required|digits:6',
            'aadharno' => 'nullable|digits:12',
            'referBy' => 'nullable|digits:10',
            'business_type' => 'required',
        ];
        $business_type = $request->business_type;
        if ($business_type == "Marketing Agency") {
            $rule['bank_name'] = "required";
            $rule['bank_account_number'] = "required|numeric|digits_between:9,18";
            $rule['bank_ifsc_code'] = "required|regex:/^[A-Z]{4}0[A-Z0-9]{6}$/";
        }
        $validator = Validator::make($request->all(), $rule, [
            'aadharno.digits' => 'Aadhar Number must be exactly 12 digits.',
            'aadharno.unique' => 'This Aadhar Number is already registered.',
        ]);
        
        $errors = [];

        // Check Laravel validator errors first
        if ($validator->fails()) {
            $errors = $validator->errors()->toArray(); // Convert to array
        }
            
        // Custom validation for PAN
        if ($request->has('panno')) {
            $panno = $request->panno;
            $panErrors = [];
    
            if (strlen($panno) !== 10) {
                $panErrors[] = "PAN Number must be exactly 10 characters long.";
            }
            if (!preg_match('/^[A-Z]{5}/', $panno)) {
                $panErrors[] = "First 5 characters of PAN must be uppercase letters (A-Z).";
            }
            if (!preg_match('/^[A-Z]{5}[0-9]{4}/', $panno)) {
                $panErrors[] = "Characters 6 to 9 of PAN must be numbers (0-9).";
            }
            if (!preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]$/', $panno)) {
                $panErrors[] = "Last character of PAN must be an uppercase letter (A-Z).";
            }
            if (\DB::table('members')->where('panno', $panno)->exists()) {
                $panErrors[] = "This PAN Number is already registered.";
            }
    
           
            if (!empty($panErrors)) {
                $errors['panno'] = $panErrors;
            }
        } else {
            $errors['panno'] = ['PAN Number is required.'];
        }
    
       
        if ($request->filled('gst')) {
            $gst = $request->gst;
            $gstErrors = [];
    
            if (strlen($gst) !== 15) {
                $gstErrors[] = "GST Number must be exactly 15 characters long.";
            }
            if (!preg_match('/^[0-9]{2}/', $gst)) {
                $gstErrors[] = "First 2 characters of GST must be numbers (State Code).";
            }
            if (!preg_match('/^[0-9]{2}[A-Z]{5}/', $gst)) {
                $gstErrors[] = "Characters 3 to 7 of GST must be uppercase letters (A-Z) (PAN Part).";
            }
            if (!preg_match('/^[0-9]{2}[A-Z]{5}[0-9]{4}/', $gst)) {
                $gstErrors[] = "Characters 8 to 11 of GST must be numbers (0-9) (PAN Part).";
            }
            if (!preg_match('/^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]/', $gst)) {
                $gstErrors[] = "Character 12 of GST must be an uppercase letter (A-Z).";
            }
            if (!preg_match('/^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z][1-9A-Z]/', $gst)) {
                $gstErrors[] = "Character 13 of GST must be a number (1-9) or an uppercase letter (A-Z).";
            }
            if (!preg_match('/^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z][1-9A-Z]Z/', $gst)) {
                $gstErrors[] = "Character 14 of GST must be 'Z'.";
            }
            if (!preg_match('/^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z][1-9A-Z]Z[0-9A-Z]$/', $gst)) {
                $gstErrors[] = "Character 15 of GST must be a number (0-9) or an uppercase letter (A-Z).";
            }
            if (\DB::table('members')->where('gst', $gst)->exists()) {
                $gstErrors[] = "This GST Number is already registered.";
            }
    
            if (!empty($gstErrors)) {
                $errors['gst'] = $gstErrors;
            }
        }
        
    
        if (!empty($errors)) {
            return response()->json(['errors' => $errors], 422);
        }
       $input = $request->all();
        if (!empty($request->referBy)) { 
            $member = Member::whereNotNull('mobile')->where('mobile', $request->referBy)->first();
            $admin = Admin::whereNotNull('mobile')->where('mobile', $request->referBy)->first();
            if ($member) {
                $input['member_referred_id'] = $member->id;
            } elseif ($admin) {
                $input['admin_referred_id'] = $admin->id;
            } else {
                return response()->json([
                    'errors' => ['referBy' => ['Your referral number does not match any Member or Admin.']]
                ], 422);
            }
        }
        if(!empty($request->password)){
            $input['password'] = bcrypt($request->password);
            $input['show_password'] = $request->show_password;
        }
        if ($request->hasFile('businessProof')) {
            $input['businessProof'] = $this->uploadFile($request, null, 'businessProof', 'user', true, 650);
        }
        if ($request->hasFile('selfie')) {
            $input['selfie'] = $this->uploadFile($request, null, 'selfie', 'user', true, 650);
        }
        if ($request->hasFile('signature')) {
            $input['signature'] = $this->uploadFile($request, null, 'signature', 'user', true, 650);
        }
        if(!empty($request->sub_category)){
            $input['sub_category'] = $request->sub_category;
        }
        if(!empty($request->sub_category)){
            $input['category_id'] = $request->category_id;
           
        }
        $input['accept_condition'] = 'Yes';
        if($request->business_type == 'Marketing Agency'){
            $sitesetting = Sitesetting::first();
            $input['commission'] = $sitesetting->reference_commission;
        }
        $user = new Member($input);
        $user->save();
        $user->refresh();
        \Log::info('Registration time User status value:', [$user->status]);
        $userMailService->sendMail($user);

        $database = new Database();
        $database->sub_category = $request->sub_category;
        $database->category_id = $request->category_id;
        $database->name = $request->name;
        $database->city = $request->city_id;
        $database->mobile_number = $request->mobile;
        $database->email = $request->email;
        $database->employee_id = 1;
        $database->status = 'Active';
        $database->save();
        /* $data = [
            'email' => $request->email,
            'subject' => 'Welcome to Singi Marketing',
            'user' => $user,
            'password' => $request->password,
        ];
        $userMailService->sendMail('admin.email-template-test', $data); */
        $userMailService->sendMail($user);
        return response()->json(['message' => 'Member registered successfully!']);
    }
  
    public function memberlogin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|numeric|digits:10',
            'password' => 'required|min:6',
        ]);
        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput()->with('toggle', true);
        }
        $member = Member::where('mobile', $request->mobile)->first();
        if (!$member) {
            session()->flash('danger', 'Member not found. Please register.');
            return back()->withInput()->with('toggle', true);
        }
        if ($member->status != 'Active') {
            session()->flash('danger', 'Your account is not active. Please contact support.');
            return back()->withInput()->with('toggle', true);
        }
        if (!Hash::check($request->password, $member->password)) {
            session()->flash('danger', 'Invalid Password.');
            return back()->withInput()->with('toggle', true);
        }
        Auth::guard('member')->login($member);
        return redirect(url('member-portal/dashboard'));
    }
    public function pass_email(){
        return view('user.password.email');
    }
    public function sendResetLink(Request $request)
    {
        $request->validate(['email' => 'required|email']);
        $status = Password::broker('members')->sendResetLink($request->only('email'));

        if ($status == Password::RESET_LINK_SENT) {
            return back()->with(['status' => __($status)]);
        }

        return back()->withErrors(['email' => __($status)]);
    }
    public function showResetForm($token)
    {
        return view('user.password.reset', ['token' => $token]);
    }

    public function reset(Request $request)
    {
        $request->validate([
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:6|max:20',
        ]);

        $status = Password::broker('members')->reset(
            $request->only('email', 'password', 'password_confirmation', 'token'),
            function ($user, $password) {
                $user->forceFill([
                    'password' => Hash::make($password),
                    'show_password' => $password,
                ])->setRememberToken(Str::random(60));

                $user->save();

                event(new PasswordReset($user));
            }
        );

        if ($status == Password::PASSWORD_RESET) {
            return redirect()->route('home')->withSuccess('Password Update successfully');
        }

        return back()->withErrors(['email' => [__($status)]]);
    }

    public function checkReferredBy(Request $request)
{
    $mobile = $request->referBy;

   
    $member = \App\Models\Member::where('mobile', $mobile)->first();

    if ($member) {
        return response()->json([
            'status' => 'found',
            'type' => 'member',
            'name' => $member->name
        ]);
    }

    // Check in Admin table
    $admin = \App\Models\Admin::where('mobile', $mobile)->first();

    if ($admin) {
        return response()->json([
            'status' => 'found',
            'type' => 'admin',
            'name' => $admin->name
        ]);
    }

    // No record found
    return response()->json([
        'status' => 'not_found',
        'message' => 'No record found'
    ]);
}
public function inquirysave(Request $request)
{
    $request->validate([
        'name' => 'required',
        'email' => 'required|email',
        'mobile' => 'required|numeric|digits:10',
        'subject' => 'required',
        'description' => 'required',
    ]);

    $input = $request->all();

    $inquiry = new Inquiry($input);
    $inquiry->save();
    return redirect()->back()->with('success', 'Inquiry saved successfully.');
}
}