<?php
namespace App\Http\Controllers\UserAuth;
use App\Http\Controllers\Controller;
use App\Services\CampaignApiService;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Slider;
use App\Models\Brand;
use App\Models\Team;
use App\Models\Download;
use App\Models\About;
use App\Models\ProjectReport;
use App\Models\Service;
use App\Models\Process;
use App\Models\Testimonial;
use App\Models\Sitesetting;
use App\Models\ConditionApply;
use App\Models\Campaign;
use App\Models\CampaignDetail;
use Barryvdh\DomPDF\Facade\Pdf;
use Auth;


class HomeController extends Controller
{

    public function boi_callback() {


        return 1;
		// $result = $boi->fetchStatement(
		// 	'310120110001190',
		// 	'207962001',// accountId
		// 	'31010',           // branchId
		// 	'2025-06-01T00:00:00.000',
		// 	'2025-06-30T00:00:00.000',
		// );

		// dd($result);
        
        // dd(json_decode($result, true));
    }


    public function home()
    {
        $sitesetting = Sitesetting::first();
        $slider = Slider::ActiveStatus()->OrderBySequence()->get();
        $services = Service::ActiveStatus()->OrderBySequence()->where('status','Active')->limit(4)->get();
        $process = Process::ActiveStatus()->OrderBySequence()->limit(5)->get();
        $testimonial = Testimonial::ActiveStatus()->OrderBySequence()->get();
        $about = About::first();
        $brand = Brand::ActiveStatus()->OrderBySequence()->get();
        $team = Team::ActiveStatus()->OrderBySequence()->limit(3)->get();

        return view('user.home')->with(['sitesetting' => $sitesetting,'slider'=>$slider,'services'=>$services,'process'=>$process,'testimonial'=>$testimonial,'brand' => $brand,'team'=>$team,'about'=>$about]);

    }
    public function contact()
    {
        $sitesetting = Sitesetting::first();
        return view('user.contact')->with(['sitesetting' => $sitesetting]);
    }
    public function about()
    {
        $sitesetting = Sitesetting::first();
        $about = About::first();
        $team = Team::ActiveStatus()->OrderBySequence()->get();
        $testimonial = Testimonial::ActiveStatus()->OrderBySequence()->get();
        $project = ProjectReport::ActiveStatus()->OrderBySequence()->get();
        return view('user.about')->with(['sitesetting' => $sitesetting,'about'=> $about,'team' => $team,'testimonial'=>$testimonial,'project' => $project]);
    }
    public function service()
    {
        $sitesetting = Sitesetting::first();
        $about = About::first();
        $service = Service::ActiveStatus()->OrderBySequence()->get();
       
        return view('user.service')->with(['sitesetting' => $sitesetting,'about'=> $about,'service' => $service]);
    }
    public function testimonial()
    {
        $sitesetting = Sitesetting::first();
        $testimonial = Testimonial::ActiveStatus()->OrderBySequence()->get();
        return view('user.testimonial')->with(['sitesetting' => $sitesetting,'testimonial'=>$testimonial]);
    }
    public function download()
    {
        $sitesetting = Sitesetting::first();
        $download = Download::ActiveStatus()->OrderBySequence()->paginate(18);
        return view('user.download')->with(['sitesetting' => $sitesetting,'download'=>$download]);
    }
    public function terms_and_conditions()
    {
        $record['sitesetting'] = Sitesetting::first();
        $record['condition'] = ConditionApply::first();
        return view('user.terms_and_conditions',$record);
    }
    public function privacy_policy()
    {
        $record['sitesetting'] = Sitesetting::first();
        $record['condition'] = ConditionApply::first();
        return view('user.privacy_policy',$record);
    }

    public function service_detail(Request $request,$slug)
    {
        $record['service'] = Service::where('slug',$slug)->ActiveStatus()->OrderBySequence()->first(); 
        $record['sitesetting'] = Sitesetting::first();
        return view('user.service-detail',$record);
    }
    public function webhook(Request $request)
    {
        info('webhook');
        info($request->all());
        $campaignApiService = new CampaignApiService();
        // $campaignApiService->generatereport($request->id);
        // $decoded = array ('{"campaign_id": "575776", "user_id":500336, "cli": "68671808087", "mobile": "8511476616", "answer_status": "Answered", "dtmf":",,", "call_sid": "8ceac4e292a9750856cf341da75e6b44","start_time": "2025-05-23_16:44:55", "answer_time":"2025-05-23_16:45:04", "end_time":"2025-05-23_16:45:14", "billing_duration":11, "hangup_cause": "Normal_Clearing", "patch_duration":6,"bridge_ring_duration": 6, "campaign_name":"Abc11213451", "retry count":0}' => NULL,);
        $decoded = $request->all();
        foreach($decoded as $key => $value){
            $decodedData = json_decode($key,true);
            // $campaignApiService->generatereport($decodedData['campaign_id']);
            // return response()->json(['message' => 'File imported successfully']);
            // dd(str_replace('_', ' ', $decodedData['start_time']));
            $record = Campaign::where('campaignId_from_api',$decodedData['campaign_id'])->first();
            if($record){
                $campaign_detail = CampaignDetail::where('campaign_id',$record->id)->where('database_number',$decodedData['mobile'])->first();
                if($campaign_detail){
                    $campaign_detail->status = isset($decodedData['answer_status']) ? $decodedData['answer_status'] : null;
                    $campaign_detail->call_status = isset($decodedData['answer_status']) ? $decodedData['answer_status'] : null;
                    $campaign_detail->call_date = isset($decodedData['start_time']) ? str_replace('_', ' ', $decodedData['start_time']) : null;
                    $campaign_detail->call_sid = isset($decodedData['call_sid']) ? $decodedData['call_sid'] : null;
                    $campaign_detail->start_time = isset($decodedData['start_time']) ? str_replace('_', ' ', $decodedData['start_time']) : null;
                    $campaign_detail->end_time = isset($decodedData['end_time']) ? str_replace('_', ' ', $decodedData['end_time']) : null;
                    $campaign_detail->call_duration = isset($decodedData['billing_duration']) ? str_replace('_', ' ', $decodedData['billing_duration']) : null;
                    $campaign_detail->update();
                }
            }
        }
       
    }

    public function webhook2(Request $request)
    {
        /*$campaignApiService = new CampaignApiService();
        $campaignApiService->generatereport('589841');*/
    }
	public function testivr($id){
		/*$campaign_detail = CampaignDetail::where('id', $id)->first();
        $sitesetting = Sitesetting::first();
        $ch = curl_init("https://backend.pbx.bonvoice.com/get-autocall-log/".$campaign_detail->call_event_id."/");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Authorization: Token ".$sitesetting->ivr_token,
        ]);
        $response = $mainResponse = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $response = json_decode($response, true);
		dd($response);
        \Log::info($response);
        if($response['status'] == '1'){
            $firstCall = $response['data'][0];
            $campaign_detail->call_duration = $firstCall['CallDuration'];
            $campaign_detail->start_time = $firstCall['StartTime'];
            $campaign_detail->end_time = $firstCall['EndTime'];
            if($firstCall['Status'] == 'CANCEL'){
                $campaign_detail->call_status = 'No Answer';
            }else if($firstCall['Status'] == 'None'){
                $campaign_detail->call_status = 'Not Connected';
            }else{
                $campaign_detail->call_status = $firstCall['Status'];
            }
            if($firstCall['AgentStatus'] == 'BUSY'){
                $campaign_detail->telecaller_status = 'No Answer';
            }else{
                $campaign_detail->telecaller_status = $firstCall['AgentStatus'];
            }
            $campaign_detail->ivrcall_id = $firstCall['callID'];
            $campaign_detail->voice_record_url = $firstCall['ResourceURL'];
            $campaign_detail->call_response = $mainResponse;
            $campaign_detail->update();
        }*/
	}

    
    public function userpdf()
    {
        $data = [
            'title' => 'Career PDF Test',
            'name'  => 'John Doe',
            'date'  => now()->format('d-m-Y'),
        ];

        $pdf = Pdf::loadView('user.pdf.carrer_pdf_test', $data);
        // return $pdf->download('carrer_pdf_test.pdf');

        return $pdf->stream('carrer_pdf_test.pdf');
    }
}