<?php
namespace App\Http\Controllers\UserAuth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\Member;
use App\Models\Admin;
use App\Models\Career;
use App\Models\Database;
use App\Models\Sitesetting;
use App\Models\JobType;
use App\Models\City;

use Auth;
use Str;
Use DB;
use Illuminate\Support\Facades\Password;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Support\Facades\Mail;


class CareerController extends Controller
{

    public function careersave(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|min:3|max:255',
            'mobile' => 'required|digits:10|unique:careers,mobile',
            'email' => 'required|email',
            'city' => 'required',
            'address' => 'required',
            'jobtype' => 'required',
            'image' => 'required|mimes:jpeg,png,jpg,pdf|max:5120',
            'aadhar_card' => 'required|digits:12|unique:careers,aadhar_card',
            'pancard' => 'required|string|size:10|unique:careers,pancard',

            'state' => 'required|string',
            'qualification' => 'required|string',
            'bank_name' => 'required|string',
            'ifsc_code' => 'required|string',
            /*'account_number' => 'required|string',*/
            'account_number' => 'required|string|unique:careers,account_number',

			
			'aadhar_card_image' => 'required|mimes:jpeg,png,jpg,pdf|max:5120',
			'pancard_image'     => 'required|mimes:jpeg,png,jpg|max:5120',
			'passbook_image'    => 'required|mimes:jpeg,png,jpg|max:5120',
			'selfie_image'      => 'required|mimes:jpeg,png,jpg|max:5120',
        ], [
            'mobile.unique' => 'The mobile number you entered already exists. Please use another number.',
            'aadhar_card.digits' => 'Aadhar Number must be exactly 12 digits.',
            'aadhar_card.unique' => 'This Aadhar number already exists. Please check and enter a different one.',

            'account_number.unique' => 'The account number you entered already exists. Please use another one.',
			'image.mimes'             => 'Please upload Resume in jpeg, png, jpg, or pdf format.',
			'aadhar_card_image.mimes' => 'Please upload Aadhar Card file in jpeg, png, jpg, or pdf format.',
			'pancard_image.mimes'     => 'Please upload Pancard image in jpeg, png, jpg format.',
			'passbook_image.mimes'    => 'Please upload Passbook image in jpeg, png, jpg format.',
			'selfie_image.mimes'      => 'Please upload Selfie image in jpeg, png, jpg format.',
			
			'image.max'             => 'Resume should be less than 5 MB.',
			'aadhar_card_image.max' => 'Aadhar card file should be less than 5 MB.',
			'pancard_image.max'     => 'Pancard image should be less than 5 MB.',
			'passbook_image.max'    => 'Passbook image should be less than 5 MB.',
			'selfie_image.max'      => 'Selfie image should be less than 5 MB.',

            'pancard.required' => 'PAN number is required.',
            'pancard.size'     => 'PAN number must be exactly 10 characters.',
            'pancard.unique' => 'This PAN number already exists. Please check and enter a different one.',
        ]);

        $errors = [];

        if ($validator->fails()) {
            $errors = $validator->errors()->toArray();
        }
        if ($request->has('pancard')) {
            $panno = $request->pancard;
            $panErrors = [];

            if (strlen($panno) !== 10) {
                $panErrors[] = "PAN Number must be exactly 10 characters long.";
            }
            if (!preg_match('/^[A-Z]{5}/', $panno)) {
                $panErrors[] = "First 5 characters of PAN must be uppercase letters (A-Z).";
            }
            if (!preg_match('/^[A-Z]{5}[0-9]{4}/', $panno)) {
                $panErrors[] = "Characters 6 to 9 of PAN must be numbers (0-9).";
            }
            if (!preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]$/', $panno)) {
                $panErrors[] = "Last character of PAN must be an uppercase letter (A-Z).";
            }
            if (!empty($panErrors)) {
                $errors['pancard'] = $panErrors;
            }
        } else {
            $errors['pancard'] = ['PAN Number is required.'];
        }

        if (!empty($errors)) {
            return response()->json(['errors' => $errors], 422);
        }

        $input = $request->all();

        if ($request->hasFile('image')) {
            $input['image'] = $this->uploadFile($request, null, 'image', 'career', false, 650);
        }

        $fileFields = [
            'aadhar_card_image' => 'aadhar_card_image',
            'pancard_image'     => 'pancard_image',
            'passbook_image'    => 'passbook_image',
            'selfie_image'      => 'selfie_image',
        ];

        foreach ($fileFields as $formField => $dbField) {
            if ($request->hasFile($formField)) {
                $input[$dbField] = $this->uploadFile($request, null, $formField, 'career/' . $dbField, false, 650);
            }
        }


        $input['job_type'] = $request->jobtype;
        $input['city'] = $request->city;
        $input['state'] = $request->state;
        $input['qualification'] = $request->qualification;
        $input['bank_name'] = $request->bank_name;
        $input['ifsc_code'] = $request->ifsc_code;
        $input['account_number'] = $request->account_number;
        $input['experience'] = $request->experience;
        $input['previous_company'] = $request->previous_company;
        $input['years'] = $request->years;
        $input['post_role'] = $request->post_role;

        $career = new Career($input);
        $career->save();

        $career = Career::find($career->id);
        $career->city_name = City::where('id', $career->city)->value('name') ?? '';
        $career->jobtype_name = JobType::where('id', $career->job_type)->value('name') ?? '';

        $this->sendAdminNotificationMail($career);

        return response()->json(['message' => 'Career Inserted Successfully!']);
    }


    /*public function careersave(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|min:3|max:255',
            'mobile' => 'required|digits:10|unique:careers,mobile',
            'email' => 'required|email',
            'city' => 'required',
            'address' => 'required',
            'jobtype' => 'required',
            'image' => 'required|mimes:jpeg,png,jpg,pdf|max:5120',
            
            'aadhar_card' => 'required|digits:12',
        ], [
            'aadhar_card.digits' => 'Aadhar Number must be exactly 12 digits.',
          
        ]);

        $errors = [];

        if ($validator->fails()) {
            $errors = $validator->errors()->toArray();
        }

        if ($request->has('pancard')) {
            $panno = $request->pancard;
            $panErrors = [];
    
            if (strlen($panno) !== 10) {
                $panErrors[] = "PAN Number must be exactly 10 characters long.";
            }
            if (!preg_match('/^[A-Z]{5}/', $panno)) {
                $panErrors[] = "First 5 characters of PAN must be uppercase letters (A-Z).";
            }
            if (!preg_match('/^[A-Z]{5}[0-9]{4}/', $panno)) {
                $panErrors[] = "Characters 6 to 9 of PAN must be numbers (0-9).";
            }
            if (!preg_match('/^[A-Z]{5}[0-9]{4}[A-Z]$/', $panno)) {
                $panErrors[] = "Last character of PAN must be an uppercase letter (A-Z).";
            }
            if (!empty($panErrors)) {
                $errors['pancard'] = $panErrors;
            }

        } else {
            $errors['pancard'] = ['PAN Number is required.'];
        } 

        if (!empty($errors)) {
            return response()->json(['errors' => $errors], 422);
        }
        
        $input = $request->all();
        
        if ($request->hasFile('image')) {
            $input['image'] = $this->uploadFile($request, null, 'image', 'career', true, 650);
        }
        $input['job_type'] = $request->jobtype;
        $input['city'] = $request->city;

        $career = new Career($input);
        $career->save();
        $career = Career::find($career->id);
        $career->city_name = City::where('id', $career->city)->value('name') ?? '';
        $career->jobtype_name = JobType::where('id', $career->job_type)->value('name') ?? '';
        $this->sendAdminNotificationMail($career);
       
        return response()->json(['message' => 'Career Inserted Successfully!']);
    }*/

    public function sendAdminNotificationMail($career)
    {
        $sitesetting = Sitesetting::first();

        if (!empty($sitesetting->admin_notification_email)) {
            $emails = explode(',', $sitesetting->admin_notification_email);
            $emails = array_filter(array_map('trim', $emails));
            $emailDetails = [
                'title'   => 'New Career Application Submitted',
                'career'  => $career,
            ];

            foreach ($emails as $email) {
                try {
                    \Mail::send('mail.admin-notification-mail', $emailDetails, function ($message) use ($email) {
                        $message->from(config('mail.from.address'), config('app.name'));
                        $message->to($email);
                        $message->subject('New Career Application Received');
                    });
                } catch (\Exception $mailError) {
                    \Log::error("Career Notification Mail Error to {$email}: " . $mailError->getMessage());
                }
            }
        }
    }


          
}