<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use App\Models\Sitesetting;
use App\Jobs\IVRReportjob;
use InvalidArgumentException;

class Controller extends BaseController {

    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    private $storage_folder = 'hardik';
	public function uploadFile($request, $record = [], $name, $path, $thumb = false, $thumbWidthSize = null, $thumbHeightSize = null) {
        if ($this->storage_folder != null) {
            $path = $this->storage_folder . '/' . $path; 
        }       
        if ($request->hasFile($name)) {
            $file = $request->file($name);
			$file_name = $file->store($path, 'public');
			if ($thumb) {
                $thumbPath = 'thumb/' . $path;
                $thumbFilePath = $thumbPath . '/' . $file->hashName();
                $this->resizeImage($file->getPathname(), $thumbFilePath, $thumbWidthSize, $thumbHeightSize);
				if (!empty($record) && Storage::exists('thumb/' . $record[$name])) {
                    Storage::delete('thumb/' . $record[$name]);
                }
            }
			if (!empty($record) && Storage::exists($record[$name])) {
                Storage::delete($record[$name]);
            }    
            return $file_name;
        }
        return null;
    }
    public function uploadFile2($request, $record = [], $name, $path, $thumb = false, $thumbWidthSize = null, $thumbHeightSize = null) {
        if ($this->storage_folder != null) {
            $path = $this->storage_folder . '/' . $path . '/' . Carbon::now()->format('Y') . '/' . Carbon::now()->format('m') . '/' . Carbon::now()->format('d');
        }
        if ($request->hasFile($name)) {
            $file = $request->file($name);
            $file_name = $file->store($path);
            if ($thumb) {
                $thumbPath = 'thumb/' . $path . '/' . $file->hashName();
                $this->resizeImage($file->getPathname(), $thumbPath, $thumbWidthSize, $thumbHeightSize);
                if (!empty($record) && Storage::exists('thumb/' . $record[$name])) {
                    Storage::delete('thumb/' . $record[$name]);
                }
            }
            if (!empty($record) && Storage::exists($record[$name])) {
                Storage::delete($record[$name]);
            }
            return $file_name;
        } else {
            return null;
        }
    }
    public function uploadMultipleFile($filee, $record = [], $name, $path, $thumb = false, $thumbWidthSize = null, $thumbHeightSize = null) {
        if ($this->storage_folder != null) {
            $path = $this->storage_folder . '/' . $path;
        }
        if (!empty($filee)) {
            $file_name = $filee->store($path);
            if ($thumb) {
                $thumbPath = 'thumb/' . $path . '/' . $filee->hashName();
                $this->resizeImage($filee->getPathname(), $thumbPath, $thumbWidthSize, $thumbHeightSize);
                if (!empty($record) && Storage::exists('thumb/' . $record[$name])) {
                    Storage::delete('thumb/' . $record[$name]);
                }
            }
            if (!empty($record) && Storage::exists($record[$name])) {
                Storage::delete($record[$name]);
            }
            return $file_name;
        } else {
            return null;
        }
    }
    public function deleteFile($record, $name, $is_thumb = false) {
        if (!empty($record)) {
            Storage::delete($record[$name]);
            if ($is_thumb) {
                Storage::delete('thumb/' . $record[$name]);
            }
        }
    }
	private function resizeImage($filePath, $outputPath, $width = null, $height = null) {
        if (!file_exists($filePath)) {
            throw new \Exception("File does not exist: $filePath");
        }
        $fileInfo = pathinfo($filePath);
        $extension = isset($fileInfo['extension']) ? strtolower($fileInfo['extension']) : '';
		$imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
		if (!in_array($extension, $imageExtensions)) {
            return;
        }
		$directory = dirname($outputPath);
        if (!Storage::exists($directory)) {
            Storage::makeDirectory($directory);
        }$originalImage = @imagecreatefromstring(file_get_contents($filePath));
        if (!$originalImage) {
            throw new \Exception("Failed to load the image: $filePath");
        }
        $originalWidth = imagesx($originalImage);
        $originalHeight = imagesy($originalImage);
        if ($width && $height) {
            $newWidth = $width;
            $newHeight = $height;
        } elseif ($width) {
            $newWidth = $width;
            $newHeight = intval($originalHeight * ($width / $originalWidth));
        } elseif ($height) {
            $newWidth = intval($originalWidth * ($height / $originalHeight));
            $newHeight = $height;
        } else {
            $newWidth = $originalWidth;
            $newHeight = $originalHeight;
        }
        $resizedImage = imagecreatetruecolor($newWidth, $newHeight);
        imagealphablending($resizedImage, false);
        imagesavealpha($resizedImage, true);
        imagecopyresampled(
            $resizedImage,
            $originalImage,
            0, 0, 0, 0,
            $newWidth,
            $newHeight,
            $originalWidth,
            $originalHeight
        );
        ob_start();
        imagepng($resizedImage);
        $resizedImageContents = ob_get_clean();
        Storage::disk('public')->put($outputPath, $resizedImageContents);
        imagedestroy($originalImage);
        imagedestroy($resizedImage);
    }
    public function uploadAudioFile($request, $record = [], $name, $path) {
        if ($this->storage_folder != null) {
            $path = $this->storage_folder . '/' . $path; 
        }
        if ($request->hasFile($name)) {
            $file = $request->file($name);
            $allowedExtensions = ['mp3', 'wav', 'aac', 'ogg', 'flac', 'm4a'];
            if (!in_array($file->getClientOriginalExtension(), $allowedExtensions)) {
                return response()->json(['error' => 'Invalid audio format. Only MP3, WAV, AAC, OGG, FLAC, M4A are allowed.'], 400);
            }
            $file_name = $file->store($path, 'public');
            if (!empty($record) && Storage::exists($record[$name])) {
                Storage::delete($record[$name]);
            }
            return $file_name;
        }
        return null;
    }
	public function generatebonovoicetoken(){
		IVRReportjob::dispatch(1);
		try {
			$sitesetting = Sitesetting::first();
			if (!$sitesetting || !$sitesetting->call_api_username || !$sitesetting->call_api_pass) {
				\Log::error('generatebonovoicetoken-error: Missing API credentials.');
				return ['success' => false,'message' => 'API credentials missing in site settings.',];
			}
			$data = ["username" => $sitesetting->call_api_username,"password" => $sitesetting->call_api_pass,];
			/*$data = ["username" => "Singifin","password" => "singif@1",];*/
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "https://obdapi2.ivrsms.com/api/obd/login");
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_TIMEOUT, 10);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
			curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json",]);
			$response = curl_exec($ch);
			$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
			if (curl_errno($ch)) {
				\Log::error('generatebonovoicetoken-error: cURL Error - ' . curl_error($ch));
				return ['success' => false,'message' => 'cURL Error: ' . curl_error($ch),];
			}
			curl_close($ch);
			$decoded = json_decode($response, true);
			if ($httpCode !== 200 || empty($decoded['token'])) {
				\Log::error('generatebonovoicetoken-error: Token not received. Response - ' . $response);
				return ['success' => false,'message' => $decoded['message'] ?? 'Failed to generate token.',];
			}
			$sitesetting->calling_token=$decoded['token'];
			$sitesetting->userid=$decoded['userid'];
			// $sitesetting->token_resonse=$decoded;
            $sitesetting->token_resonse = json_encode($decoded);
			$sitesetting->save();
            \Log::info('generatebonovoicetoken-success: - ' . json_encode($decoded)); 
			// \Log::error('generatebonovoicetoken-success: - ' . $decoded);
			// return ['success' => true,'token' => $decoded['token'],];
            return ['success' => true, 'token' => $decoded['token'], 'token_response' => $decoded, ];
		} catch (\Exception $e) {
			\Log::error('generatebonovoicetoken-error: Exception - ' . $e->getMessage());
			return [
				'success' => false,
				'message' => 'Exception: ' . $e->getMessage(),
			];
		}
	}
	public function cleanMobileNumber($number) {
		$number = str_replace(' ', '', $number);
		$number = preg_replace('/^\+?91/', '', $number);
		$number = preg_replace('/^0/', '', $number);
		return $number;
	}
	public function extractClmnevalue($input) {
		$input = trim($input);
		$input = preg_replace('/[^\P{C}\n]+/u', '', $input);
		if (preg_match('/^\s*(\d+)/', $input, $matches)) {
			return (int)$matches[1];
		}
		return null;
	}
	public function generateFileName($originalName, $type = 'upload')
	{
		$nameWithoutExtension = pathinfo($originalName, PATHINFO_FILENAME);
		$timestamp = now()->format('d-m-Y:H:i:s');
		$suffix = $type === 'error' ? '-failed' : '';
		$finalName = $nameWithoutExtension . $suffix . '-' . $timestamp;
		$finalName = preg_replace('/[^A-Za-z0-9\-:\s]/', '', $finalName);
		return $finalName;
	}
	
	
    
}
