<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Vendor;
use App\Models\User;



class VendorController extends Controller
{
    public function vendorlist(Request $request)
    {     
        /* info('vendorlist',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);
        }
        $vendor = Vendor::with(['tax','transport','marka','city_data']);

        if(!empty($user->vendor_id))
        {
            $vendor->whereIn('id',explode(',',$user->vendor_id));
        }
        if(!empty($request->city))
        {
            $vendor->where('city',$request->city);
        }
        if(!empty($request->search))
        {
            $vendor->where('name','like','%'.$request->search.'%');
        }
        $vendors = $vendor->ActiveStatus()->OrderBy('name','asc')->paginate(10);
       
        if (!$vendors) {
            return response()->json([
                'result' => '0',
                'message' => 'Vendors not found',
            ]);
        }
        $vendors->appends($request->all());
        return  response()->json([
            'result' => '1',
            'message' => 'Vendor List Fetch Successfully.',
            'vendors' => $vendors
        ]);
    }

    public function vendordetail(Request $request)
    {
     /*   info('vendordetail',$request->all()); */

        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);
        }
        $vendor = Vendor::with(['tax','transport','marka'])->where('id',$request->vendor_id)->ActiveStatus()->first();
        if($vendor->billing == 'Yes')
        {
            $vendor->billing = true;
        }else{
            $vendor->billing = false;  
        }
        $vendor->tax_name = $vendor->tax->name??'';
        $vendor->transport_name = $vendor->transport->name??'';
        $vendor->marka_name = $vendor->marka->name??'';
        unset($vendor->tax);
        unset($vendor->transport);
        unset($vendor->marka);

        if (!$vendor) {
            return response()->json([
                'result' => '0',
                'message' => 'Vendor not found.',
            ]);
        }
        return  response()->json([
            'result' => '1',
            'message' => 'Vendor Detail Fetch Successfully.',
            'vendor' => $vendor
        ]);
    }
}