<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\AppPermission;
use App\Models\Role;
use App\Models\User;
use Illuminate\Support\Str;

class UserController extends Controller
{
    public function login(Request $request)
    {
        /* info('login',$request->all()); */
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
            'password' => 'required|min:6',
        ]);
    
     
        if ($validator->fails()) {
            return  response()->json([
                'result' => '0',
                'message' => $validator->errors()->first(),
            ]);
        }
    
        
        $user = User::where('mobile', $request['mobile'])->ActiveStatus()->first();
        if(!empty($user))
        {
            
        
       
                if (!empty($user) && Hash::check($request['password'], $user->password)) {
                    
                    $token = Str::random(30);
            
                
                    $user->update([
                        'api_token' => $token,
                    
                    ]);
                    $permissions = [];
                    $role = Role::where('name',$user->role)->first();
                    $name = AppPermission::whereIn('id',explode(',',$role->permission_id))->pluck('name')->toArray();

                
                    $response['result'] = "1";
                    $response['message'] = "Success";
                    $response['token'] = $token;
                    $response['data'] = $user;
                    $response['permission'] = $name;
                } else {
                
                    $response['result'] = '0';
                    $response['message'] = 'Invalid password.';
                }
        }else{

            $response['result'] = '0';
            $response['message'] = 'User Not Found.';
        }
    
        return response()->json($response);
    }
    
 
    public function getRolePermission(Request $request)
    {
        $user = User::where('api_token', $request->api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if($user)
        {
            $role = Role::where('name',$user->role)->first();
            $name = AppPermission::whereIn('id',explode(',',$role->permission_id))->pluck('name')->toArray();

            $response['result'] = "1";
            $response['message'] = "Success";
            $response['permission'] = $name;

        }else{

            $response['result'] = '0';
            $response['message'] = 'You Are Not Authorized.';

        }
       
        return response()->json($response);
    }

}