<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use App\Models\DiscountDetail;
use App\Models\User;


class ProductController extends Controller
{
    public function getproduct(Request $request)
    {
      /* info('getproduct',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }
       
        $category = Category::where('id',$request->category_id)->select(['id','name','default_order','rate_type', 'rate'])->ActiveStatus()->first();
      
        if(!$category)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Category Not Found',
            ]);

        }
      
        
        
        $product = Product::where('category_id',$request->category_id)->ActiveStatus()->OrderBySequence()->paginate(30);
        $product->appends($request->all());
        if ($product->isEmpty()) {
            return response()->json([
                'result' => '0', 
                'message' => 'No products found for this category.',
            ]);
        }
        
            $discount_detail = DiscountDetail::where('vendor_id',$request->vendor_id)->where('category_id',$category->id)->first();
        
        if($discount_detail)
        {
            $category->discount_detail = true;
            if(!empty($request->discount) && $request->discount != 0 && $request->discount != '0' && $request->discount != null)
            {
                $discount_value = floatval($request->discount);
                $discount_detail->discount = $request->discount;
                if(!empty($request->discount_type) && $request->discount_type != 0 && $request->discount_type != '' && $request->discount_type != null)
                {
                    $discount_detail->discount_type = $request->discount_type;
                }
                $category->discount =strval($request->discount);   
            }else {
                
                $discount_value = floatval($discount_detail->discount);
                $category->discount = $discount_detail->discount;
            } 
          
          
            $category->discount_type = $discount_detail->discount_type;
           
            if($category->rate_type == 'Same Rate')
            {
                if ($discount_detail->discount_type == 'Fixed') {
                    
                    if (strpos($discount_detail->discount, '+') === 0) {
                        $category->discount_rate = $category->rate + abs($discount_value);
                      
                        $category->discount_rate = strval($category->discount_rate);
                        foreach($product as $p)
                        {
                            

                            $p->discount_rate = $p->rate + abs($discount_value);
                          
                            $p->discount_rate = strval($p->discount_rate);
                        }
                    }
                   
                    else {
                        $category->discount_rate = $category->rate - abs($discount_value);
                       
                        $category->discount_rate = strval($category->discount_rate);
                        foreach($product as $p)
                        {
                           

                            $p->discount_rate = $p->rate - abs($discount_value);
                          
                            $p->discount_rate = strval($p->discount_rate);
                        }
                    }
                }
            
               
                elseif ($discount_detail->discount_type == 'Percentage') {
                   
                   
                    $percentage_discount = round($category->rate * ($discount_value / 100));
                    if (strpos($discount_detail->discount, '+') === 0) {
                        $category->discount_rate = $category->rate + $percentage_discount;
                        
                        $category->discount_rate = strval($category->discount_rate);
                        foreach($product as $p)
                        {
                            $percentage_discount2 = $p->rate * ($discount_value / 100);
                           

                       
                            $p->discount_rate = $p->rate + $percentage_discount;
                           
                           
                            $p->discount_rate = strval($p->discount_rate);
                        }
                    }else{
                        $category->discount_rate = $category->rate - $percentage_discount;
                       
                        $category->discount_rate = strval($category->discount_rate);
                        foreach($product as $p)
                        {
                            $percentage_discount = $p->rate * ($discount_value / 100);
                            
                          
                       
                            $p->discount_rate = $p->rate - $percentage_discount;
                            
                           
                            $p->discount_rate = strval($p->discount_rate);
                        }

                    }
                }

            }else{
                
               $category->rate = '0';
               $category->discount_rate = '0';
               $category->discount = $discount_detail->discount;
              
                if ($discount_detail->discount_type == 'Fixed') {
                    
                    if (strpos($discount_detail->discount, '+') === 0) {
                        foreach($product as $p)
                        {
                            

                            $p->discount_rate = round($p->rate + abs($discount_value));
                           
                            $p->discount_rate = strval($p->discount_rate);
                        }
                       
                    }
                   
                    else {
                        foreach($product as $p)
                        {
                            $p->discount = $discount_detail->discount;

                            $p->discount_type = $discount_detail->discount_type;

                            $p->discount_rate = round($p->rate - abs($discount_value));
                           
                            $p->discount_rate = strval($p->discount_rate);
                        }
                        
                    }
                }
            
               
                elseif ($discount_detail->discount_type == 'Percentage') {

                

                    foreach($product as $p)
                    {
                       

                        $percentage_discount = round($p->rate * ($discount_value / 100));
            
                        $p->discount_rate = $p->rate - $percentage_discount;           
                       
                        $p->discount_rate = strval($p->discount_rate);

                    }
                   
                   
                  
                }

            }
        }else{
        $category->discount_detail = false;
        if(!empty($request->discount) && $request->discount != 0 && $request->discount != '0' && $request->discount != null)
        {
            $category->discount = $request->discount;
            if(!empty($request->discount_type) && $request->discount_type != 0 && $request->discount_type != '' && $request->discount_type != null)
                {
                    $category->discount_type = $request->discount_type;
                }else{
                    $category->discount_type = 'Fixed';
                }
          
            if($category->discount_type == 'Fixed')
            {
                if (strpos($request->discount, '+') === 0) {
                    $category->discount_rate = $category->rate + abs($request->discount);
                   
                    $category->discount_rate = strval($category->discount_rate);
                   
                    foreach($product as $p)
                    {
                       
    
                        $p->discount_rate = $p->rate + abs($request->discount);
                      
                        $p->discount_rate = strval($p->discount_rate);
                    }
                }
                
                else {
                    if($category->rate != null)
                    {
                        $category->discount_rate = $category->rate - abs($request->discount);
                        
                        $category->discount_rate = strval($category->discount_rate);
                    }else{
                        $category->discount_type = 'Fixed';
                        
                        $category->rate = '0';
                       
                        $category->discount_rate = '0';
                    }
                   
                    foreach($product as $p)
                    {
                        $p->discount = $request->discount;
    
                        $p->discount_type = 'Fixed';
    
                        $p->discount_rate = $p->rate - abs($request->discount);
                       
                        $p->discount_rate = strval($p->discount_rate);
                    }
                }
            }else{
                if (strpos($request->discount, '+') === 0) {

                    foreach($product as $p)
                    {
                        $p->discount = $request->discount;
    
                        $p->discount_type = 'Percentage';

                        $discount_value = floatval($request->discount);

                        $percentageamount = ($p->rate * $discount_value)/100;
    
                        $p->discount_rate = $p->rate + abs($percentageamount);
                       
                        $p->discount_rate = strval($p->discount_rate);
                    }

                }else{
                    foreach($product as $p)
                    {
                        $p->discount = $request->discount;
    
                        $p->discount_type = 'Percentage';

                        $discount_value = floatval($request->discount);

                        $percentageamount = ($p->rate * $discount_value)/100;
    
                        $p->discount_rate = $p->rate - abs($percentageamount);
                       
                        $p->discount_rate = strval($p->discount_rate);
                    }
                }

            }
            

        }else{
            if($category->rate == null)
            {
                $category->rate = '0';
            }    
            $category->discount_type = 'Fixed';
            $category->discount ='0';
            $category->discount_rate = '0';
        }

      
        }
   
     
      
        return  response()->json([
            'result' => '1',
            'message' => 'Product List Fetch Successfully.',
            'category' => $category,
            'product' => $product,
           
        ]);
    }

    public function purchasegetproduct(Request $request)
    {
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);
        }
        $category = Category::where('id',$request->category_id)->select(['id','name','default_order','rate_type', 'rate'])->ActiveStatus()->first();
        if(!$category)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Category Not Found',
            ]);
        }
        if($category->rate_type == 'Same Rate')
        {
            $category->product_rate = $category->rate;
        }else{
            $category->product_rate = '';
        }
        $product = Product::where('category_id',$request->category_id)->ActiveStatus()->OrderBySequence()->paginate(30);
        $product->appends($request->all());
        if ($product->isEmpty()) {
            return response()->json([
                'result' => '0', 
                'message' => 'No products found for this category.',
            ]);
        }
        return  response()->json([
            'result' => '1',
            'message' => 'Product List Fetch Successfully.',
            'category' => $category,
            'product' => $product,
           
        ]);
        

    }
   public function productlist(Request $request)
   {
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);
        }
        $productlist = Product::with(['category'])
        ->ActiveStatus();
       
        if(!empty($request->search))
        {
            $searchTerms = preg_split('/\s+/', trim($request->search)); 
            foreach ($searchTerms as $term) 
            {
                $productlist = $productlist->where('products.name', 'like', '%' . $term . '%');
            }
            
        }

        $productlist = $productlist ->orderBy('products.category_id', 'asc') 
        ->orderBy('products.sequence', 'asc')
        ->select('products.*')  
        ->paginate(10);

        $productlist = $productlist->appends($request->all());

        return response()->json([
            'result' => '1',
            'message' => 'Product List Fetched Successfully.',
            'productlist' => $productlist,
        ]);
    }   

}