<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\Vendor;
use App\Models\Order;
use App\Models\OrderDetail;
use App\Models\User;
use App\Models\Cart;
use App\Models\PurchaseCart;
use App\Models\Dispatched;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderDetail;
use Carbon\Carbon;

use Illuminate\Support\Str;
use File;
use Auth;
use DB;
use Illuminate\Http\Response;
use Yajra\Datatables\Datatables;


class OrderController extends Controller
{
   public function saveorder(Request $request)
   {
    /* info('saveorder',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }

        $cart = Cart::where('user_id', $user->id)
        ->where('vendor_id', $request->vendor_id)
        ->join('products', 'products.id', '=', 'carts.product_id') 
        ->whereNull('products.deleted_at')
        ->select('carts.*')
        ->get(); 

        if ($cart->IsEmpty()) {
            return response()->json([
                'result' => '0',
                'message' => 'Cart Not found.',
            ]);
        }
       
        $cart_total = Cart::where('user_id',$user->id)
        ->where('vendor_id', $request->vendor_id)
        ->join('products', 'products.id','=', 'carts.product_id') 
        ->whereNull('products.deleted_at')
        ->select('carts.*')
        ->sum('carts.total');
       
        $input['user_id'] = $user->id;
        $input['vendor_id'] =$request->vendor_id;
        $input['grandtotal'] = $cart_total;
        if($request->billing == 'true')
        {
            $input['billing'] = 'Yes';
            $input['bill_type'] = $request->bill_type;
            $input['tax_id'] = $request->tax_id;
        }
        else{
            $input['billing'] = 'No';
            $input['tax_id'] = null;
        }
        $input['billing'] = $request->billing;
       
       
        $input['default_delivery'] = $request->default_delivery;
        if($request->default_delivery == 'Transport Delivery')
        {
            $input['transport_id'] = $request->transport_id;
            $input['marka_id'] = $request->marka_id;
        }else{
            $input['transport_id'] = null;
            $input['marka_id'] = null;
        }
        
        if($request->default_delivery != 'Transport Delivery')
        {
            $input['remark'] = $request->remark;
        }else{
            $input['remark'] =null;
        }
       
       
        $input['status'] = 'OrderIn';
        $input['order_note_final'] = $request->order_note_final;
        $order = new Order($input);
        $date = Carbon::now()->format('dmY');

        $orderCount = DB::table('orders')
            ->whereDate('created_at', Carbon::now()->toDateString())
            ->count();

        $order_id = 'SO-' . $date . '-' . ($orderCount + 1);
        $order->order_id = $order_id;
       
        $order->save();
        $orderdetail_ids = [];
        if($order)
        {
            foreach($cart as $c)
            {
                $input['order_id'] = $order->id;
                $input['category_id'] = $c->category_id;
                $input['product_id'] = $c->product_id;
                $input['cart_count_id'] = $c->cart_count_id??null;
                $input['qty'] = $c->qty;
                $input['price'] = $c->price;
                $input['bundle'] = $c->bundle;
                $input['discount_type'] = $c->discount_type;
                $input['discount'] = $c->discount;
                $input['extra_product'] = $c->extra_product;
                $input['order_unique_id'] = $order->order_id;
                $input['extra_product_qty'] = $c->extra_product_qty;
                if(!empty($c->extra_product_price))
                {
               
                 $input['extra_product_price'] = $c->extra_product_price;
                }
                  
                $input['note'] = $c->note;
                $input['total'] = $c->total;
                $input['order_type'] = $c->order_type;
                $order_detail = new OrderDetail($input);
                $order_detail->save();
                if(!empty($order_detail))
                {
                    $orderdetail_ids[]  = $order_detail->id;
                }
            }
            $order->notdispatched = implode(',',$orderdetail_ids);
            $order->update();
        }

      Cart::where('user_id', $user->id)
        ->where('vendor_id', $request->vendor_id)
        ->delete(); 

        return response()->json([
            'result' => '1',
            'message' => 'Order placed successfully.',
        ]);

   }
 
   public function orderlist(Request $request)
   {
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }
        $order = Order::with(['vendor','transport','marka'])->orderBy('id','desc');
        if($user->role == 'Sales Person')
        {
            $order->where('user_id',$user->id);
        }
        
        if(!empty($request->vendor_id))
        {
            $order->where('vendor_id',$request->vendor_id);
        }
        if(!empty($request->date))
        {
            $order->whereDate('created_at', date('Y-m-d', strtotime($request->date)));
        }
        if (!empty($request->city)) {
            $order->whereHas('vendor', function ($query) use ($request) {
                $query->where('city',  $request->city );
            });
        }
        if(!empty($request->transport_id))
        {
            $order->where('transport_id',$request->transport_id);
        }
        if(!empty($request->status))
        {
            if($request->status == 'Dispatched')
        {
            $order->whereNotNull('dispatched');

        }else{
            $order->whereNotNull('notdispatched');
            $order->where('status','OrderIn');
        }

        }
        
        $order = $order->get();

        if(!$order)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Order Not Found.',
            ]);

        }
        $orderlist = $order->map(function ($o) use ($user) {
            return [
                'id' => $o->id,
                'user_id' => $user->id,
                'vendor_name' => $o->vendor->name ?? '',
                'city' => $o->vendor->city_data->name??"",
                'default_delivery' => $o->default_delivery,
                'remark' => $o->remark??'',
                'tranport_name' => $o->transport->name??'',
                'marka_name' => $o->marka->name??'',
                'can_delete' => $o->can_delete??'',
                'status' => $o->status === 'Confirm'?'OrderIn':'OrderIn',
                'total' => $o->grandtotal,
                'date' => date('d-m-Y', strtotime($o->created_at)),
                'time'=> date('h:i:s', strtotime($o->created_at)),
                'day' => date('l', strtotime($o->created_at)),
            ];
        });

        return  response()->json([
            'result' => '1',
            'message' => 'OrderList Fetched Successfully.',
            'order' => $orderlist,
            ]);
   }

   public function orderdetail(Request $request)
   {
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }

        $dispatched_ids = Dispatched::where('order_id', $request->order_id)
        ->get(['id', 'dispatched_id'])
        ->unique('dispatched_id') // Ensure unique dispatched_id values
        ->map(function ($item) use ($request) {
            return [
              
                'dispatched_id' => $item->dispatched_id,
                'link' => url('pdf/' . $request->order_id . '/' . $item->id)
            ];
        })->values();

        $order = Order::with(['vendor','tax','transport','marka'])->where('id',$request->order_id)->orderBy('id','desc');
        if($user->role == 'Sales Person')
        {
            $order->where('user_id',$user->id);
        }
        $order = $order->first();
        if(!$order)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Order Not Found.',
            ]);

        }
        $orderparmeter[] = [
                'order_id' => $order->id,
                'order_unique_id' => $order->order_id,
                'vendor_name' => $order->vendor->name ?? '',
                'city' => $order->vendor->city ?? '',
                'status' => $order->status,
                'remark' => $order->remark??'',
                'default_delivery' => $order->default_delivery,
                'transport' => $order->transport->name??'',
                'marka' => $order->marka->name??'',
                'billing' => $order->billing??'',
                'bill_type'=>$order->bill_type??'',
                'tax' => $order->tax->name??'',
                'order_note_final' => $order->order_note_final??'',
                'dispatched' => (!empty($request->status) && $request->status != 'Dispatched') ? '' : ($order->dispatched ?? ''),
                'total' => $order->grandtotal,
                'date' => date('d-m-Y h:i:s', strtotime($order->created_at)),
                'day' => date('l', strtotime($order->created_at)),
        ];
        $orderdetails = OrderDetail::where('order_id',$order->id);
        if(!empty($request->status) && $request->status != '')
        {
           
            if($request->status == 'Dispatched')
            {
                $orderdetails->where('dispatched','true');
            }else{
                
                $orderdetails->whereNull('dispatched');
            }
        }else{
            $orderdetails->whereNull('dispatched');
        }
        $orderdetails = $orderdetails->get();

        if ($orderdetails->whereNotNull('cart_count_id')->isNotEmpty()) {
        
            $orderdetails = $orderdetails->groupBy('cart_count_id');
        } else {
           
            $orderdetails = $orderdetails->groupBy('category_id');
        }

        $orderdetails_with_category = $orderdetails->sortBy(function ($details) {
            return $details->first()->category->sequence?? PHP_INT_MAX;
        })->values() 
        ->map(function ($details, $grouping_key) use($request) {
            
            $category_id = $details->first()->category_id;
            $category_name = DB::table('categories')->where('id', $category_id)->value('name');
            $rate_in = $details->first()->category->rate_in;
            $first_detail = $details->first();
            $extra_quantity_column = $details->first()->category->extra_quantity_column;
            $note = $details->first()->note;
            $rate_type = $details->first()->category->rate_type;
            
            
            $details_with_product_name =  $details->sortBy(function ($detail) {
                return $detail->product->sequence?? PHP_INT_MAX;
               })->values() 
                ->map(function ($detail) {
                $product_name = DB::table('products')->where('id', $detail->product_id)->value('name');
                 return  [
                'id' => $detail->id,
                'order_id' => $detail->order_id,
                'category_id' => $detail->category_id,
                'product_id' => $detail->product_id,
                'product_name' => $product_name,
                'price' => $detail->price,
                'quantity' => $detail->qty,
                'order_type' => $detail->order_type,
                'dispatch_qty' => $detail->dispatch_qty != null?$detail->dispatch_qty:'',
                'dispatched'=> $detail->dispatched != null ?$detail->dispatched:'',
                'extra_product' => $detail->extra_product??'',
                'diffrent_weight' => $detail->diffrent_weight??'',
                'dispatch_price' => $detail->dispatch_price??'',
                'extra_product_qty' => $detail->extra_product_qty??'',
                'extra_dispatch_qty' => $detail->extra_dispatch_qty??'',
                'note' => $detail->note??'',
                'total' => $detail->total,
                'created_at' => date('d-m-Y h:i:s', strtotime($detail->created_at)),
                'updated_at' => date('d-m-Y h:i:s', strtotime($detail->updated_at)),
        ];
    })->toArray();

   
    if ($request->status != 'Dispatched') {
        if ($first_detail->extra_product && $first_detail->extra_product_qty && $first_detail->extra != 'true')  {
            $extra_detail = [
                'id' => 0,
                'order_id' => '',
                'category_id' => $first_detail->category_id,
                'product_id' => '',
                'product_name' => $first_detail->extra_product,
                'price' => '',
                'quantity' => $first_detail->extra_product_qty,
                'dispatch_price' => $first_detail->exra_product_extra_weight ?? '',
                'extra_product_dispatch_qty' => $first_detail->extra_product_dispatch_qty ?? '',
                'extra_product_extra_qty' => $first_detail->extra_product_extra_qty ?? '',
                'bundle' => '',
                'note' => 'Extra product',
                'total' => '',
                'created_at' => '',
                'updated_at' => '',
            ];
            $details_with_product_name[] = $extra_detail;
        }
    } else {
        if ($first_detail->extra_product && $first_detail->extra_product_qty && $first_detail->extra = 'true') {
            $extra_detail = [
                'id' => 0,
                'order_id' => '',
                'category_id' => $first_detail->category_id,
                'product_id' => '',
                'product_name' => $first_detail->extra_product,
                'price' => '',
                'quantity' => $first_detail->extra_product_qty,
                'dispatch_price' => $first_detail->exra_product_extra_weight ?? '',
                'extra_product_dispatch_qty' => $first_detail->extra_product_dispatch_qty ?? '',
                'extra_product_extra_qty' => $first_detail->extra_product_extra_qty ?? '',
                'bundle' => '',
                'note' => 'Extra product',
                'total' => '',
                'created_at' => '',
                'updated_at' => '',
            ];
            $details_with_product_name[] = $extra_detail;
        }
    }
  
    $response = [
        'grouping_key' => $grouping_key,  
        'category_id' => $category_id,
        'rate_in' => $rate_in??'',
        'extra_quantity_column' => $extra_quantity_column??"",
        'category_rate_type' => $rate_type??'',
        'category_name' => $category_name,
        'cart_count_id' => $first_detail->cart_count_id??'',
        'discount_type' => $first_detail->discount_type,
        'discount' => $first_detail->discount ?? '',
        'weight' => (empty($first_detail->weight) || $first_detail->weight == 0) ? '' : ($first_detail->weight ?? ''),
        'dispatched_bundle' => $first_detail->dispatched_bundle??'',
        'note' => $note??"", 
        'bundle' => $first_detail->bundle??'',
        'details' => $details_with_product_name,
    ];

    return $response;
})->values();

         return  response()->json([
            'result' => '1',
            'order' => $orderparmeter,
            'orderdetail' => $orderdetails_with_category,
            'dispatched_id' => $dispatched_ids,
            'message' => 'OrderDetail Fetched Succesfully.',
            ]);
   }
   public function adddispatchquantity(Request $request)
   {
   
      
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);
  
        }
       $dispatchcount = Dispatched::where('order_id',$request->order_id)->orderBy('id','desc')->first();
       if (!$dispatchcount) {
        $dispatchedcount = 1;
    } else {
       
        $lastPart = (int) substr(strrchr($dispatchcount->dispatched_id, '-'), 1);
        $dispatchedcount = $lastPart + 1;
    }

        if($request->submit == '' )
        {
           
            $ordetail = OrderDetail::where('order_id',$request->order_id)->whereNull('dispatched')->get();
            foreach($ordetail as $or)
            {
                $or->dispatch_qty = null;
                $or->weight = null;
                $or->dispatched_bundle = null;
                $or->individual_weight = null;
                if($or->extra != 'true')
                {
                    $or->extra_product_dispatch_qty = null;
                    $or->extra_product_extra_qty = null;
                    $or->exra_product_extra_weight = null;
                    $or->extra_dispatch_order_price = null;
                }
                $or->update();

            }
        }

        if(!empty($request->orderdetail_id))
        {
            $orderdetail_id = explode(',',$request->orderdetail_id);
        }else{
            $orderdetail_id = null;
        }   
        $weight = explode(',',$request->weight);
        $qty  = explode(',',$request->dispatch_qty);
        $dispatched_orderdetail_id = [];
        $detail_id = explode(',',$request->orderdetail_id);
        
        $extra_product_dispatch_qty = explode(',',$request->extra_product_dispatch_qty);
        $extra_product_extra_qty = explode(',',$request->extra_product_extra_qty);
        $exra_product_extra_weight = explode(',',$request->exra_product_extra_weight);
        $dispatched_bundle = explode(',',$request->dispatched_bundle);
        $extra_dispatch_qty = explode(',',$request->extra_dispatch_qty);
        if(!empty($request->note))
        {
            $note = explode('£',$request->note);
        }
      
        if(!empty($diffrent_weight))
        {
            $diffrent_weight = explode(',',$request->diffrent_weight);
        }
        $dispatch_price = explode(',',$request->dispatch_price);
        if (!empty($orderdetail_id)) 
       {

        if($weight)
        {
            if(!empty($request->catid_for_weight))
            {
                $cat_id = explode(',',$request->catid_for_weight);
            }
            $cart_count_id = explode(',',$request->cart_count_id);
            
           
          
            if($request->submit == 'true')
            {
                foreach($cart_count_id as $key => $value)
                {
                    $cudetail = OrderDetail::where('order_id',$request->order_id)->where('dispatched','true')->whereNull('bundle')->where('cart_count_id',$value)->where('category_id',$cat_id[$key])->whereNotNull('weight')->get();
                  
                    if(!empty($cudetail))
                    {
                       foreach($cudetail as $cu)
                       {
                           $weightcategory[$value][$cat_id[$key]] = $cu->weight;
                            $cu->weight = $cu->weight + $weight[$key];
                            $cu->order_dispatch_price = $cu->weight * $cu->price;
                            $cu->update();
                            $dispa = Dispatched::where('order_id',$cu->order_id)->where('orderdetail_id',$cu->id)->first();
                            if($dispa)
                            {
                                $dispa->weight = $cu->weight;
                                $dispa->price = $cu->weight * $cu->price;
                                $dispa->update();
                            }
                       }
                    }
                }

            }
           
       
        }
        
        foreach($orderdetail_id as $key => $value)
        {
            if (!isset($qty[$key])) {
                return response()->json([
                    'result' => '0',
                    'message' => "Dispatch quantity is missing .",
                ]);
            }
            if($qty[$key] != 0)
            {

                $orderdetail = OrderDetail::where('id',$value)->first();

                
           
            if($request->submit == 'true')
            {
             
                    $order = Order::where('id',$orderdetail->order_id)->first();
                    $dispatched_orderdetail_id[] = $orderdetail->id; 
                    $existingDispatched = explode(',', $order->dispatched);
                    $existingNotDispatched = explode(',', $order->notdispatched);
                    $updatedDispatched = array_unique(array_merge($dispatched_orderdetail_id, $existingDispatched));
                    $updatedNotDispatched = array_diff($existingNotDispatched, $dispatched_orderdetail_id);
                    $dispatchedString = implode(',', $updatedDispatched);
                    $dispatchedString = rtrim($dispatchedString, ','); 
                    $order->dispatched = $dispatchedString;
                    $notDispatchedString = implode(',', $updatedNotDispatched);
                    $notDispatchedString = empty($notDispatchedString) ? null : $notDispatchedString;
                    $order->notdispatched =$notDispatchedString;
                    $order->update();
                    $orderdetail->dispatched = 'true';
                       if(!empty($request->catid_for_weight))
                       {
                    
                            foreach($cart_count_id as $cat => $cate)
                            {   
                                if($orderdetail->order_id == $request->order_id && $orderdetail->cart_count_id == $cate && $orderdetail->category_id == $cat_id[$cat])
                                {
                                    if(!empty($extra_product_dispatch_qty) && $extra_product_dispatch_qty != 'NA')
                                    {
                                        if($extra_product_dispatch_qty[$cat])
                                        {
                                           
                                            $detail = Orderdetail::where('order_id',$orderdetail->order_id)->where('cart_count_id',$orderdetail->cart_count_id)->get();
                                            foreach($detail as $de)
                                            {
                                                $de->extra_product_dispatch_qty = $extra_product_dispatch_qty[$cat] == 'NA'?Null:$extra_product_dispatch_qty[$cat];
                                               if(!empty($extra_product_extra_qty[$cat]))
                                               {
                                                 $de->extra_product_extra_qty = $extra_product_extra_qty[$cat] == 'NA'?Null:$extra_product_extra_qty[$cat];
                                               
                                               }
                                               if(!empty($exra_product_extra_weight[$cat]))
                                               {
                                                
                                                $de->exra_product_extra_weight = $exra_product_extra_weight[$cat] == 'NA'?Null:$exra_product_extra_weight[$cat];
                                                if(!empty($de->exra_product_extra_weight[$cat]))
                                            {
                                               
                                                $de->extra_dispatch_order_price = ((int)$de->exra_product_extra_weight + (int)$de->extra_product_dispatch_qty) * (int)$de->extra_product_price;
                                                $de->extra_dispatch_order_price = $de->extra_dispatch_order_price == 0 ? Null : (string) $de->extra_dispatch_order_price;
                                               
                                            }else{
                                               
                                                $de->extra_dispatch_order_price = (int)$de->extra_product_dispatch_qty * (int)$de->extra_product_price;
                                                $de->extra_dispatch_order_price = $de->extra_dispatch_order_price == 0 ? Null : (string) $de->extra_dispatch_order_price;
                                            }
                                               }
                                             
                                                $de->extra = 'true';
                                                $de->save();
                                            
                                            }
                                        }
                                    } 
                                    if($note){
                                            $loop = Orderdetail::where('order_id',$orderdetail->order_id)->where('cart_count_id',$cate)->get();
                                        foreach($loop as $l)
                                            {
                                                $l->note =  $note[$cat] == 'NA'?Null:$note[$cat];
                                                $l->update();
                                            }
                                       }
                                    if(!empty($weightcategory[$cate][$cat_id[$cat]]))
                                    {
                                        $orderdetail->weight = $weightcategory[$cate][$cat_id[$cat]] + $weight[$cat];
                                        $orderdetail->individual_weight = $weight[$cat];
                                        if($weight[$cat] != 0)
                                        {
                                            $orderdetail->order_dispatch_price =  $orderdetail->weight * $orderdetail->price;
                                        }
                                      
                                    }else{
                                        
                                        $orderdetail->weight = $weight[$cat];
                                        $orderdetail->individual_weight = $weight[$cat];
                                        if($weight[$cat] != 0)
                                        {
                                            $orderdetail->order_dispatch_price =  $orderdetail->weight * $orderdetail->price;
                                        }   
                                        if($dispatched_bundle[$cat] != 0)
                                        {
                                            $orderdetail->dispatched_bundle = $dispatched_bundle[$cat];
                                        }

                                    }
                                }
                            }
                       }
                     
                        $date = Carbon::now()->format('dmY');
                   
                       $dis = Dispatched::whereIn('orderdetail_id',$detail_id)->where('order_id',$orderdetail->order_id)->get();
                      
                        $dispatch = Dispatched::where('orderdetail_id',$orderdetail->id)->where('order_id',$orderdetail->order_id)->first();
                       
                        if(empty($dispatch))
                        {
                         
                         
                            $dis = new Dispatched;
                            $dis->order_id = $orderdetail->order_id;
                            $dis->orderdetail_id = $orderdetail->id;
                            $dis->category_id = $orderdetail->category_id;
                            $dis->product_id = trim($orderdetail->product_id);
                            $dis->qty = $qty[$key] != 'NA'?$qty[$key]:null;
                            
                            $dis->dispatched_id = $orderdetail->order_unique_id.'/'.$date.'-'.($dispatchedcount);
                            $dis->weight = $orderdetail->weight;
                            $dis->individual_weight = $orderdetail->individual_weight;
                            $dis->bundle = $orderdetail->dispatched_bundle;
                            $dis->order_type = $orderdetail->order_type;
                          
                            if($dispatch_price[$key] != 'NA')
                            {
                                $orderdetail->order_dispatch_price = ($orderdetail->dispatch_qty + $dispatch_price[$key]) * $orderdetail->price;
                            }
                            $dis->price = $orderdetail->order_dispatch_price;
                            $dis->extra_weight = $dispatch_price[$key] == 'NA'?NUll:$dispatch_price[$key];
                                
                            
                           
                            $dis->extra_product = $detail[0]->extra_product??null;
                            $dis->extra_dispatch_qty = $detail[0]->extra_product_dispatch_qty != 'NA'?$detail[0]->extra_product_dispatch_qty:Null ;
                            $dis->extra_product_weight = $detail[0]->exra_product_extra_weight != 'NA'?$detail[0]->exra_product_extra_weight:Null;
                            if($detail[0]->extra_product_dispatch_qty)
                            {
                                $dis->extra_product_price =  $detail[0]->extra_dispatch_order_price != 'NA'?$detail[0]->extra_dispatch_order_price:Null;
                            }
                          
                            $dis->cart_count_id = $orderdetail->cart_count_id;
                            
                           
                            $dis->save();  

                        
                     } 

               
            }  
            else{
              
                if(!empty($request->catid_for_weight))
                       {
                      
                            foreach($cart_count_id as $cat => $cate)
                            {   
                              
                                if($orderdetail->order_id == $request->order_id && $orderdetail->cart_count_id == $cate && $orderdetail->category_id == $cat_id[$cat])
                                {
                                        
                                    $orderdetail->weight = $weight[$cat];
                                    $orderdetail->individual_weight = $weight[$cat];
                                    
                                    if(!empty($extra_product_dispatch_qty[$cat]))
                                    {
                                        
                                        $detail = Orderdetail::where('order_id',$orderdetail->order_id)->where('cart_count_id',$orderdetail->cart_count_id)->get();
                                        foreach($detail as $de)
                                        {
                                            $de->extra_product_dispatch_qty = $extra_product_dispatch_qty[$cat] == 'NA'?Null:$extra_product_dispatch_qty[$cat];
                                           if(!empty($extra_product_extra_qty[$cat]))
                                           {
                                             $de->extra_product_extra_qty = $extra_product_extra_qty[$cat] == 'NA'?Null:$extra_product_extra_qty[$cat];
                                           }
                                           if(!empty($exra_product_extra_weight[$cat]))
                                           {
                                            $de->exra_product_extra_weight = $exra_product_extra_weight[$cat] == 'NA'?Null:$exra_product_extra_weight[$cat];
                                            if(!empty($de->exra_product_extra_weight[$cat]))
                                            {
                                                $de->extra_dispatch_order_price = ((int)$de->exra_product_extra_weight + (int)$de->extra_product_dispatch_qty) * (int)$de->extra_product_price;
                                                $de->extra_dispatch_order_price = $de->extra_dispatch_order_price == 0 ? null : (string) $de->extra_dispatch_order_price;

                                            }else{
                                               
                                                $de->extra_dispatch_order_price = (int)$de->extra_product_dispatch_qty * (int)$de->extra_product_price;
                                                $de->extra_dispatch_order_price = $de->extra_dispatch_order_price == 0 ? null : (string) $de->extra_dispatch_order_price;
                                            }
                                           }
                                        
                                            $de->save();
                                           
                                        }
                                    }  

                                    if($weight[$cat] != 0)
                                    {
                                        $orderdetail->order_dispatch_price =  $orderdetail->weight * $orderdetail->price;
                                    }

                                    if(!empty($note)){
                                        $loop = Orderdetail::where('order_id',$orderdetail->order_id)->where('cart_count_id',$cate)->get();
                                       foreach($loop as $l)
                                       {
                                         $l->note = $note[$cat] == 'NA'?Null:$note[$cat];
                                         $l->update();
                                       }
                                       }
                                       
                                        if($dispatched_bundle[$cat] != 0)
                                        {
                                           
                                            $orderdetail->dispatched_bundle = $dispatched_bundle[$cat];
                                        }
                                    
                                }
                            }
                       }

            }
    
       
                $orderdetail->dispatch_qty = $qty[$key] == 'NA'?Null:$qty[$key];
               
                $orderdetail->extra_dispatch_qty = $extra_dispatch_qty[$key] == 'NA'?Null:$extra_dispatch_qty[$key];
             
               if($dispatch_price)
               {
                $orderdetail->dispatch_price = $dispatch_price[$key] == 'NA'?Null:$dispatch_price[$key];
                if($dispatch_price[$key] != 'NA')
                {
                    $orderdetail->order_dispatch_price = ($orderdetail->dispatch_qty + $dispatch_price[$key]) * $orderdetail->price;
                }
                
               }
             
               
               
                if(!empty($request->transport_id))
                {
                    $order = Order::where('id',$orderdetail->order_id)->first();
                    if($order)
                    {
                        $order->transport_id = $request->transport_id;
                        $order->update();
    
                    }
                }
               
                
                if(!empty($request->order_note_final))
                {
                    $order = Order::where('id',$orderdetail->order_id)->first();
                    if($order)
                    {
                        $order->order_note_final = $request->order_note_final;
                        $order->update();
    
                    }
                }
                if(!empty($request->lr_no))
                {
                    $order = Order::where('id',$orderdetail->order_id)->first();
                    if($order)
                    {
                        $order->lr_no = $request->lr_no;
                        $order->update();
    
                    }
                }
             
                $orderdetail->update();
              
                if($orderdetail)
                {
                    $order = Order::where('id',$orderdetail->order_id)->first();
                    if($order->notdispatched == Null)
                    {
                        $order->status = 'Dispatched';
                        $order->update();
                    }
                    if($order)
                    {
                        $order->can_delete = 0;
                        $order->update();  
                    }
                   
                }
            }
            
            

        }
       }else{
        return  response()->json([
            'result' => '0',
            'message' => 'Orderdetails is Not Selected.',
            ]);
       }
       
        return  response()->json([
            'result' => '1',   
            'message' => 'Dispatch Quantity Added Succesfully.',
            ]);
   }

   public function purchasesaveorder(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }

    $cart = PurchaseCart::where('purchase_carts.user_id', $user->id)
    ->join('products', 'products.id', '=', 'purchase_carts.product_id') 
    ->whereNull('products.deleted_at')
    ->select('purchase_carts.*')
    ->get(); 
    
   

    if ($cart->IsEmpty()) {
        return response()->json([
            'result' => '0',
            'message' => 'Purchase Cart Not found.',
        ]);
    }
   
    $cart_total = PurchaseCart::where('purchase_carts.user_id',$user->id)
    ->join('products', 'products.id', '=', 'purchase_carts.product_id') 
    ->whereNull('products.deleted_at')
    ->select('purchase_carts.*')
    ->sum('purchase_carts.total');
   
    $input['user_id'] = $user->id;
    $input['name'] = $user->name;
    $input['mobile'] = $user->mobile;
    $input['grandtotal'] = $cart_total;
    $input['remark'] = $request->remark;
    $input['status'] = 'Ordered';
    $input['order_note_final'] = $request->order_note_final;
    $order = new PurchaseOrder($input);
    $order->save();
    $orderdetail_ids = [];
    if($order)
    {
        foreach($cart as $c)
        {
            $input['order_id'] = $order->id;
            $input['category_id'] = $c->category_id;
            $input['product_id'] = $c->product_id;
            $input['cart_count_id'] = $c->cart_count_id??null;
            $input['qty'] = $c->qty;
            $input['price'] = $c->price;
            $input['bundle'] = $c->bundle;
            $input['extra_product'] = $c->extra_product;
            $input['extra_product_qty'] = $c->extra_product_qty;
            $input['note'] = $c->note;
            $input['total'] = $c->total;
            $input['order_type'] = $c->order_type;
            $order_detail = new PurchaseOrderDetail($input);
            $order_detail->save();
            if(!empty($order_detail))
            {
                $orderdetail_ids[]  = $order_detail->id;
            }
        }
        $order->notdispatched = implode(',',$orderdetail_ids);
        $order->update();
    }

  PurchaseCart::where('user_id', $user->id)
    ->delete(); 

    return response()->json([
        'result' => '1',
        'message' => 'Purchase Order placed successfully.',
    ]);

   }
   public function purchaseorderlist(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }
    $order = PurchaseOrder::with(['user'])->orderBy('id','desc');
    if($user->role == 'Sales Person')
    {
        $order->where('user_id',$user->id);
    }
   
    if(!empty($request->status))
    {
        if($request->status == 'Dispatched')
    {
        $order->whereNotNull('dispatched');
    }else{
        $order->whereNotNull('notdispatched');
    }

    }
    
    $order = $order->get();

    if(!$order)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Order Not Found.',
        ]);

    }
    $orderlist = $order->map(function ($o) {
        return [
            'id' => $o->id,
            'user_name' => $o->user->name??'',
            'remark' => $o->remark??'',
            'status' => $o->status === 'Confirm'?'Ordered':'Ordered',
            'total' => $o->grandtotal,
            'date' => date('d-m-Y', strtotime($o->created_at)),
            'time'=> date('h:i:s', strtotime($o->created_at)),
            'day' => date('l', strtotime($o->created_at)),
        ];
    });

    return  response()->json([
        'result' => '1',
        'message' => 'PurchaseOrderList Fetched Successfully.',
        'order' => $orderlist,
        ]);
   }

   public function purchaseorderdetail(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }
    $order = PurchaseOrder::with(['user'])->where('id',$request->order_id)->orderBy('id','desc');
    if($user->role == 'Sales Person')
    {
        $order->where('user_id',$user->id);
    }
    $order = $order->first();
    if(!$order)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Order Not Found.',
        ]);

    }
    $orderparmeter[] = [
            'order_id' => $order->id,
            'status' => $order->status,
            'remark' => $order->remark??'',
            'order_note_final' => $order->order_note_final??'',
            'dispatched' => (!empty($request->status) && $request->status != 'Dispatched') ? '' : ($order->dispatched ?? ''),
            'total' => $order->grandtotal,
            'date' => date('d-m-Y h:i:s', strtotime($order->created_at)),
            'day' => date('l', strtotime($order->created_at)),
    ];
    $orderdetails = PurchaseOrderDetail::where('order_id',$order->id);
    if(!empty($request->status) && $request->status != '')
    {
       
        if($request->status == 'Dispatched')
        {
            $orderdetails->where('dispatched','true');
        }else{
         
            $orderdetails->whereNull('dispatched');
        }
    }
    $orderdetails = $orderdetails->get();

    if ($orderdetails->whereNotNull('cart_count_id')->isNotEmpty()) {
    
        $orderdetails = $orderdetails->groupBy('cart_count_id');
    } else {
       
        $orderdetails = $orderdetails->groupBy('category_id');
    }

    $orderdetails_with_category = $orderdetails->sortBy(function ($details) {
        return $details->first()->category->sequence?? PHP_INT_MAX;
    })->values() 
    ->map(function ($details, $grouping_key) {
        
        $category_id = $details->first()->category_id;
        $category_name = DB::table('categories')->where('id', $category_id)->value('name');
        $first_detail = $details->first();
        
        $details_with_product_name =  $details->sortBy(function ($detail) {
            return $detail->product->sequence?? PHP_INT_MAX;
           })->values() 
            ->map(function ($detail) {
            $product_name = DB::table('products')->where('id', $detail->product_id)->value('name');
             return  [
            'id' => $detail->id,
            'order_id' => $detail->order_id,
            'category_id' => $detail->category_id,
            'product_id' => $detail->product_id,
            'product_name' => $product_name,
            'price' => $detail->price,
            'quantity' => $detail->qty,
            'order_type' => $detail->order_type,
            'dispatch_qty' => $detail->dispatch_qty != null?$detail->dispatch_qty:'',
            'dispatched'=> $detail->dispatched != null ?$detail->dispatched:'',
            'extra_product' => $detail->extra_product??'',
            'extra_product_qty' => $detail->extra_product_qty??'',
            'note' => $detail->note??'',
            'total' => $detail->total,
            'created_at' => date('d-m-Y h:i:s', strtotime($detail->created_at)),
            'updated_at' => date('d-m-Y h:i:s', strtotime($detail->updated_at)),
    ];
})->toArray();


if ($first_detail->extra_product && $first_detail->extra_product_qty) {
    $extra_detail = [
        'id' => 0,
        'order_id' => '',
        'category_id' => $first_detail->category_id,
        'product_id' => '',
        'product_name' => $first_detail->extra_product,
        'price' => '',
        'quantity' => $first_detail->extra_product_qty,
        'bundle' => '',
        'note' => 'Extra product',
        'total' => '',
        'created_at' => '',
        'updated_at' => '',
    ];

   
    $details_with_product_name[] = $extra_detail;
}

$response = [
    'grouping_key' => $grouping_key,  
    'category_id' => $category_id,
    'category_name' => $category_name,
    'cart_count_id' => $first_detail->cart_count_id??'',
    'weight' => (!empty($first_detail->weight) && $first_detail->weight == 0) ? '' : ($first_detail->weight ?? ''),
    'dispatched_bundle' => $first_detail->dispatched_bundle??'',
    'note' => $first_detail->note ?? '',
    'bundle' => $first_detail->bundle??'',
    'details' => $details_with_product_name,
];

return $response;
})->values();

     return  response()->json([
        'result' => '1',
        'order' => $orderparmeter,
        'orderdetail' => $orderdetails_with_category,
        'message' => 'PurchaseOrderDetail Fetched Succesfully.',
        ]);
   }

   public function purchaseadddispatchqty(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }

    if($request->submit == '' )
    {
       
        $ordetail = PurchaseOrderDetail::where('order_id',$request->order_id)->whereNull('dispatched')->get();
        foreach($ordetail as $or)
        {
            $or->dispatch_qty = null;
            $or->weight = null;
            $or->dispatched_bundle = null;
            $or->update();

        }
    }

    if(!empty($request->orderdetail_id))
    {
        $orderdetail_id = explode(',',$request->orderdetail_id);
    }else{
        $orderdetail_id = null;
    }   
    $weight = explode(',',$request->weight);
    $qty  = explode(',',$request->dispatch_qty);
    $dispatched_orderdetail_id = [];
    if (!empty($orderdetail_id)) 
   {

    if($weight)
    {
        if(!empty($request->catid_for_weight))
        {
            $cat_id = explode(',',$request->catid_for_weight);
        }
        $cart_count_id = explode(',',$request->cart_count_id);
        
       
        $dispatched_bundle = explode(',',$request->dispatched_bundle);
        if($request->submit == 'true')
        {
            foreach($cart_count_id as $key => $value)
            {
                $cudetail = PurchaseOrderDetail::where('order_id',$request->order_id)->where('dispatched','true')->whereNull('bundle')->where('cart_count_id',$value)->where('category_id',$cat_id[$key])->whereNotNull('weight')->get();
              
                if(!empty($cudetail))
                {
                   foreach($cudetail as $cu)
                   {
                       $weightcategory[$value][$cat_id[$key]] = $cu->weight;
                        $cu->weight = $cu->weight + $weight[$key];
                        $cu->update();
                   }
                }
            }

        }
  
    }
    
    foreach($orderdetail_id as $key => $value)
    {
        if (!isset($qty[$key])) {
            return response()->json([
                'result' => '0',
                'message' => "Purchase Dispatch quantity is missing .",
            ]);
        }
        if($qty[$key] != 0)
        {
            $orderdetail = PurchaseOrderDetail::where('id',$value)->first();

        if($request->submit == 'true')
        {
                $order = PurchaseOrder::where('id',$orderdetail->order_id)->first();
                $dispatched_orderdetail_id[] = $orderdetail->id; 
                $existingDispatched = explode(',', $order->dispatched);
                $existingNotDispatched = explode(',', $order->notdispatched);
                $updatedDispatched = array_unique(array_merge($dispatched_orderdetail_id, $existingDispatched));
                $updatedNotDispatched = array_diff($existingNotDispatched, $dispatched_orderdetail_id);
                $dispatchedString = implode(',', $updatedDispatched);
                $dispatchedString = rtrim($dispatchedString, ','); 
                $order->dispatched = $dispatchedString;
                $notDispatchedString = implode(',', $updatedNotDispatched);
                $notDispatchedString = empty($notDispatchedString) ? null : $notDispatchedString;
                $order->notdispatched =$notDispatchedString;
                $order->update();
                $orderdetail->dispatched = 'true';
                   if(!empty($request->catid_for_weight))
                   {
                
                        foreach($cart_count_id as $cat => $cate)
                        {   
                            
                         
                            if($orderdetail->order_id == $request->order_id && $orderdetail->cart_count_id == $cate && $orderdetail->category_id == $cat_id[$cat])
                            {
                               
                                if(!empty($weightcategory[$cate][$cat_id[$cat]]))
                                {
                                    $orderdetail->weight = $weightcategory[$cate][$cat_id[$cat]] + $weight[$cat];
                                  
                                }else{
                                    
                                    $orderdetail->weight = $weight[$cat];
                                    if($dispatched_bundle[$cat] != 0)
                                    {
                                        $orderdetail->dispatched_bundle = $dispatched_bundle[$cat];
                                    }
                                }
                            }
                        }
                   }
           
        }
        else{
          
            if(!empty($request->catid_for_weight))
                   {
                        foreach($cart_count_id as $cat => $cate)
                        {   
                            if($orderdetail->order_id == $request->order_id && $orderdetail->cart_count_id == $cate && $orderdetail->category_id == $cat_id[$cat])
                            {
                              
                                    $orderdetail->weight = $weight[$cat];
                                   
                                    if($dispatched_bundle[$cat] != 0)
                                    {
                                       
                                        $orderdetail->dispatched_bundle = $dispatched_bundle[$cat];
                                    }
                                
                            }
                        }
                   }

        }

   
            $orderdetail->dispatch_qty = $qty[$key] == 'NA'?null:$qty[$key];
    
            if(!empty($request->order_note_final))
            {
                $order = PurchaseOrder::where('id',$orderdetail->order_id)->first();
                if($order)
                {
                    $order->order_note_final = $request->order_note_final;
                    $order->update();
                }
            }
            $orderdetail->update();
        }
    
    }
   }else{
    return  response()->json([
        'result' => '0',
        'message' => 'Purchase Orderdetails is Not Selected.',
        ]);
   }
    return  response()->json([
        'result' => '1',   
        'message' => 'Purchase Dispatch Quantity Added Succesfully.',
        ]);
   }

   public function orderdelete(Request $request)
   {
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }
        $order_id = $request->order_id;
        $order = Order::where('id',$order_id)->first();
        if(!$order)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Order Not Found.',
            ]);

        }

        $order->delete();

        return  response()->json([
            'result' => '1',   
            'message' => 'Order Delted Succesfully.',
            ]);

   }

   public function dispatchorderhistory(Request $request)
   {
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }
        $order = Order::with(['vendor','transport','marka'])->orderBy('id','desc');
        
        
        if(!empty($request->vendor_id))
        {
            $order->where('vendor_id',$request->vendor_id);
        }
        if(!empty($request->date))
        {
            $order->whereDate('created_at', date('Y-m-d', strtotime($request->date)));
        }
        if (!empty($request->city)) {
            $order->whereHas('vendor', function ($query) use ($request) {
                $query->where('city',  $request->city );
            });
        }
        if(!empty($request->transport_id))
        {
            $order->where('transport_id',$request->transport_id);
        }
       
        
        $order = $order->get();

        if(!$order)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Order Not Found.',
            ]);

        }
        $orderlist = $order->map(function ($o) use ($user) {
            return [
                'id' => $o->id,
                'user_id' => $user->id,
                'vendor_name' => $o->vendor->name ?? '',
                'city' => $o->vendor->city_data->name??"",
                'default_delivery' => $o->default_delivery,
                'remark' => $o->remark??'',
                'tranport_name' => $o->transport->name??'',
                'marka_name' => $o->marka->name??'',
                'can_delete' => $o->can_delete??'',
                'status' => $o->status === 'Confirm'?'Ordered':'Ordered',
                'total' => $o->grandtotal,
                'date' => date('d-m-Y', strtotime($o->created_at)),
                'time'=> date('h:i:s', strtotime($o->created_at)),
                'day' => date('l', strtotime($o->created_at)),
            ];
        });

        return  response()->json([
            'result' => '1',
            'message' => 'OrderList Fetched Successfully.',
            'order' => $orderlist,
            ]);
   }

   public function addorderinprocess(Request $request)
   {
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);
        }
        $order = Order::where('id',$request->order_id)->first();
        if(!$order)
        {
            return  response()->json([
                'result' => '0',
                'message' => 'Order Not Found.',
                ]);
        }
        $order->status = 'InProcess';
        $order->update();
        return  response()->json([
            'result' => '1',
            'message' => 'Order Added InProcess Successfully.',
            ]);
   }
   public function inprocessorderhistory(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }
    $order = Order::select('orders.*')
    ->join('vendors', 'orders.vendor_id', '=', 'vendors.id')
    ->join('cities', 'vendors.city', '=', 'cities.id')
    ->where('orders.status', 'InProcess')
    ->orderBy('cities.name', 'asc')
    ->orderBy('orders.id', 'desc')
    ->with(['vendor', 'transport', 'marka']);
   
    
    
    if(!empty($request->vendor_id))
    {
        $order->where('vendor_id',$request->vendor_id);
    }
    if(!empty($request->date))
    {
        $order->whereDate('created_at', date('Y-m-d', strtotime($request->date)));
    }
    if (!empty($request->city)) {
        $order->whereHas('vendor', function ($query) use ($request) {
            $query->where('city',  $request->city );
        });
    }
    if(!empty($request->transport_id))
    {
        $order->where('transport_id',$request->transport_id);
    }
   
    
    $order = $order->get();

    if(!$order)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Order Not Found.',
        ]);

    }
    $orderlist = $order->map(function ($o) use ($user) {
        return [
            'id' => $o->id,
            'user_id' => $user->id,
            'vendor_name' => $o->vendor->name ?? '',
            'city' => $o->vendor->city_data->name??"",
            'default_delivery' => $o->default_delivery,
            'remark' => $o->remark??'',
            'tranport_name' => $o->transport->name??'',
            'marka_name' => $o->marka->name??'',
            'can_delete' => $o->can_delete??'',
            'status' => $o->status === 'InProcess'?'InProcess':'InProcess',
            'total' => $o->grandtotal,
            'date' => date('d-m-Y', strtotime($o->created_at)),
            'time'=> date('h:i:s', strtotime($o->created_at)),
            'day' => date('l', strtotime($o->created_at)),
        ];
    });

    return  response()->json([
        'result' => '1',
        'message' => 'InProcess OrderList Fetched Successfully.',
        'order' => $orderlist,
        ]);
   }

   public function orderhistorydetail(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }

   


    $order = Order::with(['vendor','tax','transport','marka'])->where('id',$request->order_id)->orderBy('id','desc');
    if($user->role == 'Sales Person')
    {
        $order->where('user_id',$user->id);
    }
    $order = $order->first();
    if(!$order)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Order Not Found.',
        ]);

    }
    $orderparmeter[] = [
            'order_id' => $order->id,
            'order_unique_id' => $order->order_id,
            'vendor_name' => $order->vendor->name ?? '',
            'city' => $order->vendor->city ?? '',
            'status' => $order->status,
            'remark' => $order->remark??'',
            'default_delivery' => $order->default_delivery,
            'transport' => $order->transport->name??'',
            'marka' => $order->marka->name??'',
            'billing' => $order->billing??'',
            'bill_type'=>$order->bill_type??'',
            'tax' => $order->tax->name??'',
            'order_note_final' => $order->order_note_final??'',
            'dispatched' => (!empty($request->status) && $request->status != 'Dispatched') ? '' : ($order->dispatched ?? ''),
            'total' => $order->grandtotal,
            'date' => date('d-m-Y h:i:s', strtotime($order->created_at)),
            'day' => date('l', strtotime($order->created_at)),
    ];
    $orderdetails = OrderDetail::where('order_id',$order->id);
   
    $orderdetails = $orderdetails->get();

    if ($orderdetails->whereNotNull('cart_count_id')->isNotEmpty()) {
    
        $orderdetails = $orderdetails->groupBy('cart_count_id');
    } else {
       
        $orderdetails = $orderdetails->groupBy('category_id');
    }

    $orderdetails_with_category = $orderdetails->sortBy(function ($details) {
        return $details->first()->category->sequence?? PHP_INT_MAX;
    })->values() 
    ->map(function ($details, $grouping_key) {
        
        $category_id = $details->first()->category_id;
        $category_name = DB::table('categories')->where('id', $category_id)->value('name');
        $rate_in = $details->first()->category->rate_in;
        $first_detail = $details->first();
        $extra_quantity_column = $details->first()->category->extra_quantity_column;
        $note = $details->first()->note;
        $rate_type = $details->first()->category->rate_type;
        
        
        $details_with_product_name =  $details->sortBy(function ($detail) {
            return $detail->product->sequence?? PHP_INT_MAX;
           })->values() 
            ->map(function ($detail) {
            $product_name = DB::table('products')->where('id', $detail->product_id)->value('name');
             return  [
            'id' => $detail->id,
            'order_id' => $detail->order_id,
            'category_id' => $detail->category_id,
            'product_id' => $detail->product_id,
            'product_name' => $product_name,
            'price' => $detail->price,
            'quantity' => $detail->qty,
            'order_type' => $detail->order_type,
            'dispatch_qty' => $detail->dispatch_qty != null?$detail->dispatch_qty:'',
            'dispatched'=> $detail->dispatched != null ?$detail->dispatched:'',
            'extra_product' => $detail->extra_product??'',
            'diffrent_weight' => $detail->diffrent_weight??'',
            'dispatch_price' => $detail->dispatch_price??'',
            'extra_product_qty' => $detail->extra_product_qty??'',
            'extra_dispatch_qty' => $detail->extra_dispatch_qty??'',
            'note' => $detail->note??'',
            'total' => $detail->total,
            'created_at' => date('d-m-Y h:i:s', strtotime($detail->created_at)),
            'updated_at' => date('d-m-Y h:i:s', strtotime($detail->updated_at)),
    ];
})->toArray();


if ($first_detail->extra_product && $first_detail->extra_product_qty) {
    $extra_detail = [
        'id' => 0,
        'order_id' => '',
        'category_id' => $first_detail->category_id,
        'product_id' => '',
        'product_name' => $first_detail->extra_product,
        'price' => '',
        'quantity' => $first_detail->extra_product_qty,
        'dispatch_price' =>$first_detail->extra_product_extra_qty??'',
        'bundle' => '',
        'note' => 'Extra product',
        'total' => '',
        'created_at' => '',
        'updated_at' => '',
    ];

   
    $details_with_product_name[] = $extra_detail;
}

$response = [
    'grouping_key' => $grouping_key,  
    'category_id' => $category_id,
    'rate_in' => $rate_in??'',
    'extra_quantity_column' => $extra_quantity_column??"",
    'category_rate_type' => $rate_type??'',
    'category_name' => $category_name,
    'cart_count_id' => $first_detail->cart_count_id??'',
    'discount_type' => $first_detail->discount_type,
    'discount' => $first_detail->discount ?? '',
    'weight' => (empty($first_detail->weight) || $first_detail->weight == 0) ? '' : ($first_detail->weight ?? ''),
    'dispatched_bundle' => $first_detail->dispatched_bundle??'',
    'note' => $note??"", 
    'bundle' => $first_detail->bundle??'',
    'details' => $details_with_product_name,
];

return $response;
})->values();

     return  response()->json([
        'result' => '1',
        'order' => $orderparmeter,
        'orderdetail' => $orderdetails_with_category,
        'message' => 'OrderDetail Fetched Succesfully.',
        ]);
   }
   public function orderhistorylist(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }
    $order = Order::with(['vendor','transport','marka'])->orderBy('id','desc');
    if($user->role == 'Sales Person')
    {
        $order->where('user_id',$user->id);
    }
    
    if(!empty($request->vendor_id))
    {
        $order->where('vendor_id',$request->vendor_id);
    }
    if(!empty($request->date))
    {
        $order->whereDate('created_at', date('Y-m-d', strtotime($request->date)));
    }
    if (!empty($request->city)) {
        $order->whereHas('vendor', function ($query) use ($request) {
            $query->where('city',  $request->city );
        });
    }
    if(!empty($request->transport_id))
    {
        $order->where('transport_id',$request->transport_id);
    }
    if(!empty($request->status))
    {
        if($request->status == 'Dispatched')
    {
        $order->whereNotNull('dispatched');

    }else{
        $order->whereNotNull('notdispatched');
    }

    }
    
    $order = $order->get();

    if(!$order)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Order Not Found.',
        ]);

    }
    $orderlist = $order->map(function ($o) use ($user) {
        return [
            'id' => $o->id,
            'user_id' => $user->id,
            'vendor_name' => $o->vendor->name ?? '',
            'city' => $o->vendor->city_data->name??"",
            'default_delivery' => $o->default_delivery,
            'remark' => $o->remark??'',
            'tranport_name' => $o->transport->name??'',
            'marka_name' => $o->marka->name??'',
            'can_delete' => $o->can_delete??'',
            'status' => $o->status === 'Confirm'?'OrderIn':'OrderIn',
            'total' => $o->grandtotal,
            'date' => date('d-m-Y', strtotime($o->created_at)),
            'time'=> date('h:i:s', strtotime($o->created_at)),
            'day' => date('l', strtotime($o->created_at)),
        ];
    });

    return  response()->json([
        'result' => '1',
        'message' => 'OrderList Fetched Successfully.',
        'order' => $orderlist,
        ]);
   }
}