<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\City;
use App\Models\User;
use App\Models\Vendor;

class CityController extends Controller
{
    public function getCity(Request $request)
    {
        /* info('getCity',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);
        }
        $city = City::ActiveStatus()->OrderBy('name','asc');
        $vendor_id = explode(',',$user->vendor_id);
        $city_ids = [];
        if(!empty($vendor_id))
        {
            foreach($vendor_id as $v)
            {
                $vendor = Vendor::where('id',$v)->ActiveStatus()->first();
                if ($vendor) {
                    $city_ids[] = $vendor->city; 
                }
              
            }
        }
        $city_ids = array_unique($city_ids);
        $city = $city->whereIn('id', $city_ids)->get();
       
        if(!empty($city))
        {
            return  response()->json([
                'result' => '1',
                'message' => 'City List Fetch Successfully.',
                'city' => $city
            ]);
        }else{
            return  response()->json([
                'result' => '0',
                'message' => 'City Not Found.',
               
            ]);
        }
    }
}