<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\Category;
use App\Models\Cart;
use App\Models\PurchaseCart;
use App\Models\User;
use App\Models\Section;

class CategoryController extends Controller
{
    public function categorylist(Request $request)
    {
       /* info('categorylist',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }
        $categoryQuery = Category::query();

        if (!empty($request->section_id)) {
            $categoryQuery->where('section_id', $request->section_id);
        }

        
        if(!empty($request->search))
        {
            $searchTerms = preg_split('/\s+/', trim($request->search)); 
            foreach ($searchTerms as $term) {
                $categoryQuery->where('name', 'like', '%' . $term . '%');
            }
        }
   
    
     
    
    $categories = $categoryQuery->ActiveStatus()->OrderBySequence()->paginate(10);

   
    $categories->appends($request->all());

    foreach($categories as $c)
    {
        $c->section_name = Section::where('id', $c->section_id)->pluck('name')->first();
    }
   
    return response()->json([
        'result' => '1',
        'message' => 'Category List Fetched Successfully.',
        'categories' => $categories,
    ]);
    }

    public function bundleinfo(Request $request)
    {
   
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }
        $category = Category::where('id',$request->category_id)->ActiveStatus()->first();
        if(!$category)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Category Not Found.',
            ]);

        }
        if(empty($category->bundle_info))
        {

            return  response()->json([
                'result' => '0',
                'message' => 'Bundle Info Not Added In This Category.',
                ]);
        }
        return  response()->json([
            'result' => '1',
            'bundle' => $category->bundle_info,
            'message' => 'Bundle Info Fetched Successfully.',
            ]);
    }

        public function categorycount(Request $request)
        {
            $api_token = $request->api_token;
            $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
            if(!$user)
            {
                return  response()->json([
                'result' => '0',
                'message' => 'Invalid Aunthantication',
                ]);

            }

            $uniqueCategoryCount = Cart::where('user_id', $user->id)
            ->where('vendor_id',$request->vendor_id)
            ->select('cart_count_id') 
            ->groupBy('cart_count_id') 
            ->get();
        
          $count = (string) $uniqueCategoryCount->count();
        
        if (!$count) {
            return response()->json([
                'result' => '0',
                'message' => 'No categories found in cart',
            ]);
        }
        return  response()->json([
            'result' => '1',
            'category_count' =>$count,
            'message' => 'Category Count Fetched Successfully.',
            ]);
    }

    public function purchasecategorycount(Request $request)
        {
            $api_token = $request->api_token;
            $user = User::where('api_token',$api_token)->whereNotNull('api_token')->ActiveStatus()->first();
            if(!$user)
            {
                return  response()->json([
                'result' => '0',
                'message' => 'Invalid Aunthantication',
                ]);

            }

            $uniqueCategoryCount = PurchaseCart::where('user_id', $user->id)
            ->select('cart_count_id') 
            ->groupBy('cart_count_id') 
            ->get();
        
          $count = (string) $uniqueCategoryCount->count();
        
        if (!$count) {
            return response()->json([
                'result' => '0',
                'message' => 'No categories found in PurchaseCart',
            ]);
        }
        return  response()->json([
            'result' => '1',
            'category_count' =>$count,
            'message' => 'Purchase Category Count Fetched Successfully.',
            ]);
    }
}