<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DB;
use Illuminate\Http\Response;
use App\Models\Category;
use App\Models\Product;
use App\Models\Vendor;
use App\Models\User;
use App\Models\Cart;
use App\Models\PurchaseCart;


class CartController extends Controller
{
    public function addtocart(Request $request)
    {
        /* info('addtocart',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token', $api_token)->WhereNotNull('api_token')->ActiveStatus()->first();
    
        if (!$user) {
            return response()->json([
                'result' => '0',
                'message' => 'Invalid Authentication',
            ]);
        }
    
        $category = Category::where('id', $request->category_id)->ActiveStatus()->first();
        if (!$category) {
            return response()->json([
                'result' => '0',
                'message' => 'Category not found',
            ]);
        }
    
        $vendor = Vendor::where('id', $request->vendor_id)->ActiveStatus()->first();
        if (!$vendor) {
            return response()->json([
                'result' => '0',
                'message' => 'Vendor not found',
            ]);
        }
    
        if (!empty($request->product_id)) {
            $product_ids = explode(',', $request->product_id);
            $qty = explode(',', $request->qty);
            $price = !empty($request->price) ? explode(',', $request->price) : [];
            $lastCountId = Cart::withTrashed()->whereNotNull('cart_count_id')->orderBy('id','desc')->first();
           
            if ($lastCountId ) {
                $cart_count_id = (int)$lastCountId->cart_count_id + 1; 
            } else {
                $cart_count_id = 1 ; 
            }
            
            $cart_count_id = (string)$cart_count_id;
           
            $message = [];
            if ($request->add_again == 'No') {  
              
                foreach ($product_ids as $key => $value) {
                   
                    $cartItems = Cart::where('vendor_id', $request->vendor_id)
                                    ->where('user_id',$user->id)
                                     ->where('category_id', $request->category_id)
                                     ->where('product_id', $value)
                                     ->get();
                    
                    if ($cartItems->isNotEmpty()) {
                       
                        $totalQuantity = $cartItems->sum(function ($item) {
                            return (float) $item->qty; 
                        });
                       
                       
                        $product = Product::find($value);
                        $category = Category::find($request->category_id);
            
                       
                        $message[] = "Product: {$product->name} ({$totalQuantity}).";
                    }
                }
                
            }
       
            if (count($message) > 0) 
            {
                $cartMessage = implode("\n", $message);
        
                return response()->json(['message' => $cartMessage]);
            }
            else{
                $request->add_again = 'Yes';
            }
            
          if($request->add_again == 'Yes')
        {
            foreach ($product_ids as $key => $value) {
                $cart = new Cart;
              
                $cart->cart_count_id = $cart_count_id;
                $cart->user_id = $user->id;
                $cart->vendor_id = $request->vendor_id;
                $cart->category_id = $request->category_id;
                $cart->product_id = $value;
                $cart->discount_type = $request->discount_type;
                $cart->discount = $request->discount;
                $cart->order_type = $request->order_type;
              
                $quantity = isset($qty[$key]) ? ($qty[$key] == 0 ? '-' : (float) $qty[$key]) : '-';
                
                $productPrice = isset($price[$key]) ? (float) $price[$key] : 0;
    
                $cart->qty = $quantity;
                
                if ($category->rate_type == 'Same Rate') {
                    $cart->price = (float) $request->product_rate;
                    $cart->total = $quantity > 0 ? $quantity * (float) $request->product_rate : (float) $request->product_rate;
                    $cart->extra_product_price = $request->product_rate;
                } else {
                    $cart->price = $productPrice;
                    $cart->total = $quantity > 0 ? $quantity * $productPrice : $productPrice;
                    if(!empty($request->extra_product_price))
                    {
                        $cart->extra_product_price = $request->extra_product_price??'';
                    }
                }
                
                if (!empty($request->bundle)) {
                    $cart->bundle = $request->bundle??'';
                }
                
                if (!empty($request->extra_product)) {
                    $cart->extra_product = $request->extra_product??'';
                }
    
                if (!empty($request->extra_product_qty)) {
                    $cart->extra_product_qty = $request->extra_product_qty??'';
                }
               
     
                if (!empty($request->note)) {
                    $cart->note = $request->note??'';
                }
             
                $cart->save();
              
            }
        }
            return response()->json([
                'result' => '1',
                'message' => 'Products added to cart successfully.',
            ]);
        } 
    }
   
   public function cartlist(Request $request)
   {

    /* info('cartlist',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token',$api_token)->WhereNotNull('api_token')->ActiveStatus()->first();
        if(!$user)
        {
            return  response()->json([
            'result' => '0',
            'message' => 'Invalid Aunthantication',
            ]);

        }
        $cartQuery = Cart::join('products', 'carts.product_id', '=', 'products.id')
        ->select('carts.*')  
        ->whereNull('products.deleted_at') 
        ->with(['category', 'vendor']);

        if(!empty($user))
        {
            $cartQuery->where('user_id',$user->id);
        }
        
    if (!empty($request->vendor_id)) {
        $cartQuery->where('vendor_id', $request->vendor_id);
    }

  
    $cart = $cartQuery->get();

   

    if($cart->IsEmpty())
    {
        return  response()->json([
            'result' => '0',
            'message' => 'Cart Not Found.',
            ]); 
    }
    $categoryList = [];
    $total = 0;
    foreach ($cart as $cartItem) {
        $categoryName = $cartItem->category ? $cartItem->category->name : null; 
        $productName = $cartItem->product ? $cartItem->product->name : null; 
        $cartCountId = $cartItem->cart_count_id;
        $total  += $cartItem->total;
       
        $simplifiedCartItem = [
            'id' => $cartItem->id,
            'category_id' => $cartItem->category_id,
            'product_id' => $cartItem->product_id,
            'category_name' => $categoryName,
            'product_name' => $productName,
            'vendor_id' => $cartItem->vendor_id,
            'price' => $cartItem->price, 
            'order_type' => $cartItem->order_type, 
            'qty' => $cartItem->qty, 
            'total' => $cartItem->total, 
            'bundle' => $cartItem->bundle??'',
            'extra_product' => $cartItem->extra_product, 
            'extra_product_qty' => $cartItem->extra_product_qty, 
            'note' => $cartItem->note??'', 
            'status' => $cartItem->status,  
            'created_at' => date('Y-m-d H:i:s',strtotime($cartItem->created_at)), 
            'updated_at' => date('Y-m-d H:i:s',strtotime($cartItem->updated_at)), 
            'deleted_at' => !empty($cartItem->deleted_at)?date('Y-m-d H:i:s',strtotime($cartItem->deleted_at)):null,  

            ];
        if ($cartCountId) {
           
            if (!isset($categoryList[$cartCountId])) {
                $categoryList[$cartCountId] = [
                    'cart_count_id' => $cartCountId,
                    'category_name' => $categoryName,
                    'category_id' => $cartItem->category_id,
                    'products' => [],
                    'discount_type' => $cartItem->discount_type??'',
                    'discount' => $cartItem->discount??'',
                    'category_total' => 0,
                    'bundle' => '',
                    'note' => '',
                ];
            }

            $categoryList[$cartCountId]['products'][] = $simplifiedCartItem;
            $categoryList[$cartCountId]['category_total'] = strval(number_format($categoryList[$cartCountId]['category_total'] + $cartItem->total, 2, '.', ''));
            $categoryList[$cartCountId]['bundle'] = $cartItem->bundle??'';
            $categoryList[$cartCountId]['note'] = $cartItem->note??"";

        } else {
          
            if (!isset($categoryList[$categoryName])) {
                $categoryList[$categoryName] = [
                    'category_name' => $categoryName,
                    'category_id' => $cartItem->category_id,
                    'products' => [],
                    'category_total' => 0,
                    'discount_type' => $cartItem->discount_type??'',
                    'discount' => $cartItem->discount??'',
                    'bundle' => '',
                    'note' => '',
                ];
            }

            $categoryList[$categoryName]['products'][] = $simplifiedCartItem;
            $categoryList[$categoryName]['category_total'] = strval(number_format($categoryList[$categoryName]['category_total'] + $cartItem->total, 2, '.', ''));
            $categoryList[$categoryName]['bundle'] = $cartItem->bundle??'';
            $categoryList[$categoryName]['note'] = $cartItem->note??'';
        }
    }
   
    $finalCategoryList = array_values($categoryList);
    return response()->json([
        'result' => '1',
        'cart' => $finalCategoryList,
        'grand_total' => strval(number_format($total,2,'.','')),
        'message' => 'Cartlist fetched successfully.', 
    ]);
   }

   public function cartdelete(Request $request)
   {
   /* info('cartdelete',$request->all()); */
        $api_token = $request->api_token;
        $user = User::where('api_token', $api_token)->whereNotNull('api_token')->ActiveStatus()->first();

        if (!$user) {
            return response()->json([
                'result' => '0',
                'message' => 'Invalid Authentication',
            ]);
        }
        $category_id = $request->category_id;
        $vendor_id = $request->vendor_id;
        $count_id = $request->cart_count_id;
        if($count_id != null && $count_id != 0 && $count_id != '')
        {
            $cart = Cart::where('user_id',$user->id)->where('vendor_id',$vendor_id)->where('category_id',$category_id)->where('cart_count_id',$count_id)->delete();
        }
         else{
            $cart = Cart::where('user_id',$user->id)->where('vendor_id',$vendor_id)->where('category_id',$category_id)->delete();
         }
        if (!$cart) {
            return response()->json([
                'result' => '0',
                'message' => 'Cart Not Found.',
            ]);
        }
        return response()->json([
            'result' => '1',
            'message' => 'Cart Deleted Successfully.', 
        ]);
   }

   public function purchaseaddtocart(Request $request)
   {
         /* info('addtocart',$request->all()); */
         $api_token = $request->api_token;
         $user = User::where('api_token', $api_token)->WhereNotNull('api_token')->ActiveStatus()->first();
     
         if (!$user) {
             return response()->json([
                 'result' => '0',
                 'message' => 'Invalid Authentication',
             ]);
         }
     
         $category = Category::where('id', $request->category_id)->ActiveStatus()->first();
         if (!$category) {
             return response()->json([
                 'result' => '0',
                 'message' => 'Category not found',
             ]);
         }
     
        
     
         if (!empty($request->product_id)) {
             $product_ids = explode(',', $request->product_id);
             $qty = explode(',', $request->qty);
             $price = !empty($request->price) ? explode(',', $request->price) : [];
             $lastCountId = PurchaseCart::withTrashed()->whereNotNull('cart_count_id')->orderBy('id','desc')->first();
            
             if ($lastCountId ) {
                 $cart_count_id = (int)$lastCountId->cart_count_id + 1; 
             } else {
                 $cart_count_id = 1; 
             }
             
             $cart_count_id = (string)$cart_count_id;
             $message = [];
             if ($request->add_again == 'No') {  
                
                 foreach ($product_ids as $key => $value) {
                    
                     $cartItems = PurchaseCart::where('user_id',$user->id)
                                      ->where('category_id', $request->category_id)
                                      ->where('product_id', $value)
                                      ->get();
                     
                     if ($cartItems->isNotEmpty()) {
                       
                         $totalQuantity = $cartItems->sum('qty');
             
                        
                         $product = Product::find($value);
                         $category = Category::find($request->category_id);
             
                        
                         $message[] = "Product: {$product->name} ({$totalQuantity}).";
                     }
                 }
                 
             }
         
             if (count($message) > 0) 
             {
                 $cartMessage = implode("\n", $message);
         
                 return response()->json(['message' => $cartMessage]);
             }
             else{
                 $request->add_again = 'Yes';
             }
             
           if($request->add_again == 'Yes')
         {
             foreach ($product_ids as $key => $value) {
                 $cart = new PurchaseCart;
                
                 $cart->cart_count_id = $cart_count_id;
                 $cart->user_id = $user->id;
                
                 $cart->category_id = $request->category_id;
                 $cart->product_id = $value;
            
              
                 $cart->order_type = $request->order_type;
               
                 $quantity = isset($qty[$key]) ? ($qty[$key] == 0 ? '-' : (float) $qty[$key]) : '-';
                 
                 $productPrice = isset($price[$key]) ? (float) $price[$key] : 0;
     
                 $cart->qty = $quantity;
                 
                 if ($category->rate_type == 'Same Rate') {
                    $cart->price = (float) $request->product_rate;
                    $cart->total = $quantity > 0 ? $quantity * (float) $request->product_rate : (float) $request->product_rate;
                } else {
                    $cart->price = $productPrice;
                    $cart->total = $quantity > 0 ? $quantity * $productPrice : $productPrice;
                }
                
                 
                 
                 if (!empty($request->bundle)) {
                     $cart->bundle = $request->bundle??'';
                 }
                 
                 if (!empty($request->extra_product)) {
                     $cart->extra_product = $request->extra_product??'';
                 }
     
                 if (!empty($request->extra_product_qty)) {
                     $cart->extra_product_qty = $request->extra_product_qty??'';
                 }
      
                 if (!empty($request->note)) {
                     $cart->note = $request->note??'';
                 }
                
                 $cart->save();
               
             }
         }
             return response()->json([
                 'result' => '1',
                 'message' => 'Products added to PurchaseCart successfully.',
             ]);
         } 
   }

   public function purchasecartdelete(Request $request)
   {
        $api_token = $request->api_token;
        $user = User::where('api_token', $api_token)->whereNotNull('api_token')->ActiveStatus()->first();

        if (!$user) {
            return response()->json([
                'result' => '0',
                'message' => 'Invalid Authentication',
            ]);
        }
        $category_id = $request->category_id;
    
        $count_id = $request->cart_count_id;
        if($count_id != null && $count_id != 0 && $count_id != '')
        {
            $cart = PurchaseCart::where('user_id',$user->id)->where('category_id',$category_id)->where('cart_count_id',$count_id)->delete();
        }
        else{
            $cart = PurchaseCart::where('user_id',$user->id)->where('category_id',$category_id)->delete();
        }
        if (!$cart) {
            return response()->json([
                'result' => '0',
                'message' => 'PurchaseCart Not Found.',
            ]);
        }
        return response()->json([
            'result' => '1',
            'message' => 'PurchaseCart Deleted Successfully.', 
        ]);
   }
   public function purchasecartlist(Request $request)
   {
    $api_token = $request->api_token;
    $user = User::where('api_token',$api_token)->WhereNotNull('api_token')->ActiveStatus()->first();
    if(!$user)
    {
        return  response()->json([
        'result' => '0',
        'message' => 'Invalid Aunthantication',
        ]);

    }
    $cartQuery = PurchaseCart::join('products', 'purchase_carts.product_id', '=', 'products.id')
    ->select('purchase_carts.*')  
    ->whereNull('products.deleted_at') 
    ->with(['category']);

    if(!empty($user))
    {
        $cartQuery->where('user_id',$user->id);
    }
    



$cart = $cartQuery->get();



if($cart->IsEmpty())
{
    return  response()->json([
        'result' => '0',
        'message' => 'PurchaseCart Not Found.',
        ]); 
}
$categoryList = [];
$total = 0;
foreach ($cart as $cartItem) {
    $categoryName = $cartItem->category ? $cartItem->category->name : null; 
    $productName = $cartItem->product ? $cartItem->product->name : null; 
    $cartCountId = $cartItem->cart_count_id;
    $total  += $cartItem->total;
   
    $simplifiedCartItem = [
        'id' => $cartItem->id,
        'category_id' => $cartItem->category_id,
        'product_id' => $cartItem->product_id,
        'category_name' => $categoryName,
        'product_name' => $productName,
        'price' => $cartItem->price, 
        'order_type' => $cartItem->order_type, 
        'qty' => $cartItem->qty, 
        'total' => $cartItem->total, 
        'bundle' => $cartItem->bundle??'',
        'extra_product' => $cartItem->extra_product, 
        'extra_product_qty' => $cartItem->extra_product_qty, 
        'note' => $cartItem->note??'', 
        'status' => $cartItem->status,  
        'created_at' => date('Y-m-d H:i:s',strtotime($cartItem->created_at)), 
        'updated_at' => date('Y-m-d H:i:s',strtotime($cartItem->updated_at)), 
        'deleted_at' => !empty($cartItem->deleted_at)?date('Y-m-d H:i:s',strtotime($cartItem->deleted_at)):null,  

        ];
    if ($cartCountId) {
       
        if (!isset($categoryList[$cartCountId])) {
            $categoryList[$cartCountId] = [
                'cart_count_id' => $cartCountId,
                'category_name' => $categoryName,
                'category_id' => $cartItem->category_id,
                'products' => [],
                'category_total' => 0,
                'bundle' => '',
                'note' => '',
            ];
        }

        $categoryList[$cartCountId]['products'][] = $simplifiedCartItem;
        $categoryList[$cartCountId]['category_total'] = strval(number_format($categoryList[$cartCountId]['category_total'] + $cartItem->total, 2, '.', ''));
        $categoryList[$cartCountId]['bundle'] = $cartItem->bundle??'';
        $categoryList[$cartCountId]['note'] = $cartItem->note??"";

    } else {
      
        if (!isset($categoryList[$categoryName])) {
            $categoryList[$categoryName] = [
                'category_name' => $categoryName,
                'category_id' => $cartItem->category_id,
                'products' => [],
                'category_total' => 0,
                'bundle' => '',
                'note' => '',
            ];
        }

        $categoryList[$categoryName]['products'][] = $simplifiedCartItem;
        $categoryList[$categoryName]['category_total'] = strval(number_format($categoryList[$categoryName]['category_total'] + $cartItem->total, 2, '.', ''));
        $categoryList[$categoryName]['bundle'] = $cartItem->bundle??'';
        $categoryList[$categoryName]['note'] = $cartItem->note??'';
    }
}

$finalCategoryList = array_values($categoryList);
return response()->json([
    'result' => '1',
    'cart' => $finalCategoryList,
    'grand_total' => strval(number_format($total,2,'.','')),
    'message' => 'PurchaseCartlist fetched successfully.', 
]);
   }
}