<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\VendorData\Vendor;
use Illuminate\Http\Request;


class VendorController extends Controller
{
    public function __construct() {}

    private $data = [
        'route' => 'admin.vendor.',
        'title' => 'Vendor',
        'menu' => 'Vendor',
        'submenu' => '',
    ];

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        if ($request->ajax()) {

            $customerSearch = $request->search['value'];

            $records = Vendor::orderBy('id', 'desc')->select('vendors.*')
                ->when($request->startDate, function ($query) use ($request) {
                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                    if ($request->endDate) {
                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                        return $query->whereBetween('vendors.created_at', [$startDate, $endDate]);
                    }

                    return $query->where('vendors.created_at', '>=', $startDate);
                })
                ->when($request->endDate && ! $request->startDate, function ($query) use ($request) {
                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                    return $query->where('vendors.created_at', '<=', $endDate);
                })
                ->when($customerSearch, function ($query) use ($customerSearch) {
                    return $query->where(function ($q) use ($customerSearch) {
                        $q->where('name', 'like', '%'.$customerSearch.'%');
                    });
                });

            return datatables()->of($records)
                ->addIndexColumn()
                ->addColumn('name', function ($record) {
                    return '<div style="text-align:center;">
                                <a href="'.url('secure-dashboard/vendor/'.$record->id.'/edit').'">'.$record->name.'</a>
                            </div>';
                })
                ->addColumn('action', function ($record) {
                    return '&nbsp;<a href="'.url('secure-dashboard/vendor/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                        '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })

                ->rawColumns(['name', 'status', 'action', 'block_status'])
                ->make(true);
        }

        return view('admin.vendor.index', $this->data);

    }

    public function create()
    {
        $this->data['title'] = 'Create Vendor';
        $vendor = [];

        return view('admin.vendor.create')->with(['vendor' => $vendor, $this->data]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        $input = $request->all();
        Vendor::create($input);

        if ($request->ajax() == true) {

            return response()->json([
                'success' => true,
                'message' => 'Vendor Added successfully',
                'redirect_url' => url('secure-dashboard/vendor'),
            ]);

        }

        return redirect('secure-dashboard/vendor')->withSuccess('Vendor Added successfully');
    }

    public function show($id)
    {

        $vendor = Vendor::find($id);

        return view('admin.vendor.show')->with(['vendor' => $vendor, $this->data]);
    }

    public function edit($id)
    {
        $this->data['title'] = 'Edit Vendor';
        $vendor = Vendor::find($id);

        return view('admin.vendor.create', ['vendor' => $vendor, $this->data]);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'name' => 'required',
        ]);
        $input = $request->all();
        $vendor = Vendor::find($id);
        $vendor->update($input);

        if ($request->ajax()) {

            return response()->json([
                'success' => true,
                'message' => 'Vendor Update successfully',
                'redirect_url' => url('secure-dashboard/vendor'),
            ]);

        }

        return redirect('secure-dashboard/vendor')->withSuccess('Vendor Update successfully');
    }

    public function destroy(Request $request)
    {
        $vendor = Vendor::find($request->id);
        if ($vendor) {

            $vendor->delete();

            return response()->json([
                'success' => true,
                'message' => 'Vendor Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Vendor not found',
        ]);
    }
}
