<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Transport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TransportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {}

    private $data = [
        'route' => 'admin.transport.',
        'title' => 'Transport',
        'menu' => 'Transport',
        'submenu' => '',
    ];

    public function index(Request $request)
    {

        if ($request->ajax()) {

            $customerSearch = $request->search['value'];

            $records = Transport::OrderBy('name', 'asc')
                ->when($request->startDate, function ($query) use ($request) {
                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                    if ($request->endDate) {
                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                        return $query->whereBetween('categories.created_at', [$startDate, $endDate]);
                    }

                    return $query->where('categories.created_at', '>=', $startDate);
                })
                ->when($request->endDate && ! $request->startDate, function ($query) use ($request) {
                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                    return $query->where('categories.created_at', '<=', $endDate);
                })
                ->when($customerSearch, function ($query) use ($customerSearch) {
                    return $query->where(function ($q) use ($customerSearch) {
                        $q->where('name', 'like', '%'.$customerSearch.'%');
                    });
                });

            return datatables()->of($records)
                ->addIndexColumn()

            /*->editColumn('sequence', function ($record){
               return '<input style="width: 80px;color:black;" type="text" class="mainfrrom form-control txt_inline_edit sequence_update inline_update digitonly" name="" value="'.$record['sequence'].'" row_id="'.$record['id'].'" field="sequence" />';
            })*/
                ->editColumn('address', function ($record) {
                    return strip_tags($record->address);
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch ">
                         <input class="form-check-input status-toggle" style="" id="statusToggle" type="checkbox" data-id="'.$record->id.'" data-status="'.$record->status.'" '.($record->status == 'Active' ? 'checked' : '').'></div>';
                })
                ->addColumn('action', function ($record) {
                    return ' <a href="'.url('admin/transport/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          ' <button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status', 'action'])
                ->make(true);
        }

        return view('admin.transport.index', $this->data);

    }

    public function create()
    {
        $transport = [];

        return view('admin.transport.create')->with(['transport' => $transport]);
    }

    public function store(Request $request)
    {

        $sValidationRules = [
            'name' => 'required',
            /*
            'address'=>'required',
            'phone'=>'required|numeric|digits:10',
            'area'=>'required',*/

        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $input = $request->all();
        $admin = new Transport($input);
        $admin->save();

        return redirect('admin/transport')->withSuccess('Transport Added successfully');

    }

    public function show($id)
    {
        $transport = Transport::find($id);

        return view('admin.transport.show')->with(['transport' => $transport]);
    }

    public function transportView(Request $request)
    {
        $transport = Transport::find($request->id);

        $data = [
            'transport' => $transport,
        ];

        return response()->json([
            'success' => true,
            'html' => view('admin.transport.transportView', $data)->render(),
        ]);
    }

    public function edit($id)
    {
        $transport = Transport::find($id);

        return view('admin.transport.create', ['transport' => $transport]);
    }

    public function update(Request $request, $id)
    {
        $input = $request->all();
        $transport = Transport::find($id);

        if ($request->ajax()) {
            if (! empty($request->currentStatus)) {
                if ($request->currentStatus == 'Active') {
                    $transport->status = 'Inactive';
                } else {
                    $transport->status = 'Active';
                }
            }
            if (! empty($request->sequence)) {

                $transport->sequence = $request->sequence;
            } else {

                $transport->sequence = null;

            }

            $transport->save();
            $response['success'] = true;
            $response['message'] = 'Transport Update successfully';

            return response()->json($response);
        }
        $sValidationRules = [
            'name' => 'required',
            /*  'address'=>'required',
                                 'phone'=>'required|numeric|digits:10',
                                 'area'=>'required',*/

        ];

        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $transport->update($input);

        return redirect('admin/transport')->withSuccess('Transport Update successfully');
    }

    public function destroy(Request $request)
    {

        $transport = Transport::find($request->id);

        if ($transport) {
            $transport->delete();

            return response()->json([
                'success' => true,
                'message' => 'Transport Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Transport not found',
        ]);
    }
}
