<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Team;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;


class TeamController extends Controller
{
    public function __construct() {}

    private $data = [
        'route' => 'admin.team.',
        'title' => 'Team',
        'menu' => 'Team',
        'submenu' => '',
    ];

    public function index(Request $request)
    {
        if (! rolemanagement('Team', 1)) {
            abort(401);
        }
        if ($request->ajax()) {
            $records = Team::OrderBySequence('asc');

            return datatables()->of($records)
                ->addIndexColumn()
                ->editColumn('image', function ($record) {
                    return '<img src="'.(! empty($record->image_url) ? $record->image_url : url('assets/admin/images/not-available (1).jpg')).'" width="50px" height="50px" >';
                })
                ->editColumn('sequence', function ($record) {
                    return '<input style="width: 80px;color:black;" type="text" class="mainfrrom form-control txt_inline_edit sequence_update inline_update digitonly" name="" value="'.$record['sequence'].'" row_id="'.$record['id'].'" field="sequence" />';
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch ">
                            <input class="form-check-input status-toggle" style=""  id="statusToggle" type="checkbox" data-id="'.$record->id.'" data-status="'.$record->status.'" '.($record->status == 'Active' ? 'checked' : '').'></div>';
                })
                ->editColumn('created_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->created_at));
                })
                ->editColumn('updated_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->updated_at));
                })
                ->addColumn('action', function ($record) {
                    $html = '<div class="d-flex gap-1 align-items-center justify-content-center">';
                    if (rolemanagement('Team', 3)) {
                        $html .= ' <a type="button" onclick="teamedit('.$record->id.')" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit">
                                <i class="fas fa-edit"></i>
                            </a> ';
                    }
                    if (rolemanagement('Team', 4)) {
                        $html .= '<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fas fa-trash"></i></button>';
                    }
                    $html .= '</div>';

                    return $html;

                })
                ->rawColumns(['status', 'sequence', 'image', 'action'])
                ->make(true);
        }

        return view('admin.team.index', $this->data);

    }

    public function create()
    {
        if (! rolemanagement('Team', 2)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => true,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }

        return response()->json([
            'success' => true,
            'html' => view('admin.team.create')->render(),
        ]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'description' => 'required',
            'designation' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5120',
        ]);

        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }
        $imageName = null;
        if ($request->hasFile('image')) {
            $imageName = $this->uploadFile($request, null, 'image', 'team', true, 650);
        }

        $record = new Team;
        $record->name = $request->name;
        $record->description = $request->description;
        $record->designation = $request->designation;
        $record->sequence = $request->sequence;
        $record->image = $imageName;
        $record->status = 'Active';
        $record->save();

        $response['success'] = true;
        $response['message'] = 'Create successfully';

        return response()->json($response);
    }

    public function edit(Request $request)
    {
        if (! rolemanagement('Team', 3)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => true,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }
        $record = Team::find($request->id);
        $data = [
            'team' => $record,
        ];

        return response()->json([
            'success' => true,
            'html' => view('admin.team.edit', $data)->render(),
        ]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'description' => 'required',
            'designation' => 'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:5120',
        ]);
        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }

        $record = Team::find($request->id);
        $record->name = $request->name;
        $record->sequence = $request->sequence;
        $record->designation = $request->designation;
        $record->description = $request->description;

        if ($request->hasFile('image')) {
            if ($record->image && Storage::exists($record->image)) {
                Storage::delete($record->image);
            }
            $imageName = $this->uploadFile($request, null, 'image', 'team', true, 650);
            $record->image = $imageName;
        }
        $record->update();

        $response['success'] = true;
        $response['message'] = 'Update successfully';

        return response()->json($response);
    }

    public function sequence_update(Request $request)
    {
        $record = Team::find($request->id);
        if ($request->ajax()) {
            if (! empty($request->currentStatus)) {
                if ($request->currentStatus == 'Active') {
                    $record->status = 'Inactive';
                } else {
                    $record->status = 'Active';
                }
                $record->save();
                $response['success'] = true;
                $response['message'] = 'Update successfully';

                return response()->json($response);
            }
            if (! empty($request->sequence)) {
                $record->sequence = $request->sequence;
            } else {
                $record->sequence = null;
            }
            $record->update();
            $response['success'] = true;
            $response['message'] = 'Update successfully';

            return response()->json($response);
        }
    }

    public function destroy(Request $request)
    {
        if (! rolemanagement('Team', 4)) {
            abort(401);
        }
        $record = Team::find($request->id);
        if ($record) {
            if ($record->image && Storage::exists($record->image)) {
                Storage::delete($record->image);
            }
            $record->delete();

            return response()->json([
                'success' => true,
                'message' => 'Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Team not found',
        ]);
    }

    public function sliderdelete($id)
    {
        Team::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';

        return response()->json($response);
    }
}
