<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Tax;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TaxController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {}

    private $data = [
        'route' => 'admin.tax.',
        'title' => 'Tax',
        'menu' => 'Tax',
        'submenu' => '',
    ];

    public function index(Request $request)
    {

        if ($request->ajax()) {

            $customerSearch = $request->search['value'];

            $records = Tax::OrderBySequence('asc')
                ->when($request->startDate, function ($query) use ($request) {
                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                    if ($request->endDate) {
                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                        return $query->whereBetween('categories.created_at', [$startDate, $endDate]);
                    }

                    return $query->where('taxes.created_at', '>=', $startDate);
                })
                ->when($request->endDate && ! $request->startDate, function ($query) use ($request) {
                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                    return $query->where('taxes.created_at', '<=', $endDate);
                })
                ->when($customerSearch, function ($query) use ($customerSearch) {
                    return $query->where(function ($q) use ($customerSearch) {
                        $q->where('name', 'like', '%'.$customerSearch.'%');
                    });
                });

            return datatables()->of($records)
                ->addIndexColumn()
                ->editColumn('sequence', function ($record) {
                    return '<input style="width: 80px;color:black;" type="text" class="mainfrrom form-control txt_inline_edit sequence_update inline_update digitonly" name="" value="'.$record['sequence'].'" row_id="'.$record['id'].'" field="sequence" />';
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch ">
                         <input class="form-check-input status-toggle" style="" id="statusToggle" type="checkbox" data-id="'.$record->id.'" data-status="'.$record->status.'" '.($record->status == 'Active' ? 'checked' : '').'></div>';
                })
                ->addColumn('action', function ($record) {
                    return '<a class="btn btn-sm btn-primary taxView text-white" data-id="'.$record->id.'" ><i class="fe fe-eye"></i></a> '.
                          ' <a href="'.url('admin/tax/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          ' <button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status', 'sequence', 'action'])
                ->make(true);
        }

        return view('admin.tax.index', $this->data);

    }

    public function create()
    {
        $tax = [];

        return view('admin.tax.create')->with(['tax' => $tax]);
    }

    public function store(Request $request)
    {

        $sValidationRules = [
            'name' => 'required',

        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $input = $request->all();
        $admin = new Tax($input);
        $admin->save();

        return redirect('admin/tax')->withSuccess('Tax Added successfully');

    }

    public function show($id)
    {
        $tax = Tax::find($id);

        return view('admin.tax.show')->with(['tax' => $tax]);
    }

    public function taxView(Request $request)
    {
        $tax = Tax::find($request->id);
        $data = [
            'tax' => $tax,
        ];

        return response()->json([
            'success' => true,
            'html' => view('admin.tax.taxView', $data)->render(),
        ]);
    }

    public function edit($id)
    {
        $tax = Tax::find($id);

        return view('admin.tax.create', ['tax' => $tax]);
    }

    public function update(Request $request, $id)
    {
        $input = $request->all();
        $tax = Tax::find($id);

        if ($request->ajax()) {
            if (! empty($request->currentStatus)) {
                if ($request->currentStatus == 'Active') {
                    $tax->status = 'Inactive';
                } else {
                    $tax->status = 'Active';
                }
            }
            if (! empty($request->sequence)) {

                $tax->sequence = $request->sequence;
            } else {

                $tax->sequence = null;

            }

            $tax->save();
            $response['success'] = true;
            $response['message'] = 'Update successfully';

            return response()->json($response);
        }
        $sValidationRules = [
            'name' => 'required',

        ];

        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $tax->update($input);

        return redirect('admin/tax')->withSuccess('Tax Update successfully');
    }

    public function destroy(Request $request)
    {

        $tax = Tax::find($request->id);

        if ($tax) {
            $tax->delete();

            return response()->json([
                'success' => true,
                'message' => 'Tax Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Tax not found',
        ]);
    }
}
