<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Sitesetting;
use Illuminate\Http\Request;

class SitesettingController extends Controller
{
    private $data = [
        'route' => 'admin.sitesetting.',
        'title' => 'Site Setting',
        'menu' => 'sitesetting',
        'submenu' => '',
    ];

    public function sitesetting()
    {
        if (! rolemanagement('Site Setting', 1)) {
            abort(401);
        }
        $this->data['sitesetting'] = Sitesetting::first();

        return view('admin.sitesetting.create', $this->data);
    }

    public function updatesitesetting(Request $request)
    {
        $record = Sitesetting::first();
        $admin = $request->all();

        /* if ($request->filled('admin_notification_email')) {
            $emails = explode(',', $request->admin_notification_email);
            $emails = array_filter(array_map('trim', $emails));
            $admin['admin_notification_email'] = implode(',', $emails);
        } */

        if ($request->filled('admin_notification_email')) {
            $emails = explode(',', $request->admin_notification_email);
            $emails = array_filter(array_map('trim', $emails), function ($email) {
                return filter_var($email, FILTER_VALIDATE_EMAIL);
            });
            $admin['admin_notification_email'] = implode(',', $emails);
        }
        if ($request->hasFile('image')) {
            if ($record['image'] && file_exists(public_path($record['image']))) {
                unlink(public_path($record['image']));
            }
            $imageName = 'image_'.rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/sitesetting/image'), $imageName);
            $admin['image'] = 'uploads/sitesetting/image/'.$imageName;
        }
        if ($request->hasFile('fevicon')) {
            if ($record['fevicon'] && file_exists(public_path($record['fevicon']))) {
                unlink(public_path($record['fevicon']));
            }
            $feviconName = 'favicon_'.rand().time().'.'.$request->fevicon->extension();
            $request->fevicon->move(public_path('uploads/sitesetting/favicon'), $feviconName);
            $admin['fevicon'] = 'uploads/sitesetting/favicon/'.$feviconName;
        }
        if ($request->hasFile('profile_photo')) {
            if ($record['profile_photo'] && file_exists(public_path($record['profile_photo']))) {
                unlink(public_path($record['profile_photo']));
            }
            $imageName = 'profile_photo_'.rand().time().'.'.$request->profile_photo->extension();
            $request->profile_photo->move(public_path('uploads/sitesetting/profile_photo'), $imageName);
            $admin['profile_photo'] = 'uploads/sitesetting/profile_photo/'.$imageName;
        }
        $record->update($admin);

        return redirect()->back()->withSuccess('Update successfully');
    }
}
