<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Section;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SectionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {}

    private $data = [
        'route' => 'admin.section.',
        'title' => 'Section',
        'menu' => 'Section',
        'submenu' => '',
    ];

    public function index(Request $request)
    {

        if ($request->ajax()) {

            $customerSearch = $request->search['value'];

            $records = Section::OrderBySequence('asc')
                ->when($request->startDate, function ($query) use ($request) {
                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                    if ($request->endDate) {
                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                        return $query->whereBetween('categories.created_at', [$startDate, $endDate]);
                    }

                    return $query->where('categories.created_at', '>=', $startDate);
                })
                ->when($request->endDate && ! $request->startDate, function ($query) use ($request) {
                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));

                    return $query->where('categories.created_at', '<=', $endDate);
                })
                ->when($customerSearch, function ($query) use ($customerSearch) {
                    return $query->where(function ($q) use ($customerSearch) {
                        $q->where('name', 'like', '%'.$customerSearch.'%');
                    });
                });

            return datatables()->of($records)
                ->addIndexColumn()
                ->editColumn('image', function ($record) {
                    return '<img src="'.(! empty($record->image_url) ? $record->image_url : url('public/assets/admin/images/not-available (1).jpg')).'" width="100px" height="100px" >';
                })
                ->editColumn('sequence', function ($record) {
                    return '<input style="width: 80px;color:black;" type="text" class="mainfrrom form-control txt_inline_edit sequence_update inline_update digitonly" name="" value="'.$record['sequence'].'" row_id="'.$record['id'].'" field="sequence" />';
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch ">
                        <input class="form-check-input status-toggle" style=""  id="statusToggle" type="checkbox" data-id="'.$record->id.'" data-status="'.$record->status.'" '.($record->status == 'Active' ? 'checked' : '').'></div>';
                })
                ->addColumn('action', function ($record) {
                    return '<a class="btn btn-sm btn-primary sectionView text-white" data-id="'.$record->id.'" ><i class="fe fe-eye"></i></a> '.
                          ' <a href="'.url('admin/section/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          ' <button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status', 'sequence', 'image', 'action'])
                ->make(true);
        }

        return view('admin.section.index', $this->data);

    }

    public function create()
    {
        $section = [];

        return view('admin.section.create')->with(['section' => $section]);
    }

    public function store(Request $request)
    {

        $sValidationRules = [
            'name' => 'required',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $input = $request->all();

        $admin = new Section($input);
        $admin->save();

        return redirect('admin/section')->withSuccess('Section Added successfully');

    }

    public function show($id)
    {
        $section = Section::find($id);

        return view('admin.section.show')->with(['section' => $section]);
    }

    public function sectionView(Request $request)
    {
        $section = Section::find($request->id);
        $data = [
            'section' => $section,
        ];

        return response()->json([
            'success' => true,
            'html' => view('admin.section.sectionView', $data)->render(),
        ]);
    }

    public function edit($id)
    {
        $section = Section::find($id);

        return view('admin.section.create', ['section' => $section]);
    }

    public function update(Request $request, $id)
    {

        $section = Section::find($id);

        if ($request->ajax()) {

            if (! empty($request->currentStatus)) {

                if ($request->currentStatus == 'Active') {
                    $section->status = 'Inactive';
                } else {
                    $section->status = 'Active';
                }
                $section->save();
                $response['success'] = true;
                $response['message'] = 'Update successfully';

                return response()->json($response);
            }
            if (! empty($request->sequence)) {

                $section->sequence = $request->sequence;
            } else {

                $section->sequence = null;

            }

            $section->save();
            $response['success'] = true;
            $response['message'] = 'Update successfully';

            return response()->json($response);
        }

        $sValidationRules = [
            'name' => 'required',

        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $input = $request->all();

        $section->update($input);

        return redirect('admin/section')->withSuccess('Section Update successfully');
    }

    public function destroy(Request $request)
    {

        $section = Section::find($request->id);

        if ($section) {

            $section->delete();

            return response()->json([
                'success' => true,
                'message' => 'Section Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Section not found',
        ]);
    }

    public function sectiondelete($id)
    {

        Section::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';

        return response()->json($response);
    }
}
