<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\PermissionType;
use App\Models\Role;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RoleController extends Controller
{
    private $data = [
        'route' => 'admin.role.',
        'title' => 'Role',
        'menu' => 'Role',
        'submenu' => '',
    ];

    public function index(Request $request)
    {
        if (! rolemanagement('Role', 1)) {
            abort(401);
        }
        if ($request->ajax()) {
            $records = Role::OrderBySequence('asc');

            return datatables()->of($records)
                ->addIndexColumn()
                ->editColumn('sequence', function ($record) {
                    return '<input style="width: 80px;color:black;" type="text" class="form-control digitonly sequence_update" name="" value="'.$record['sequence'].'" row_id="'.$record['id'].'" field="sequence" />';
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch ">
                            <input class="form-check-input status-toggle" style="" id="statusToggle" type="checkbox" data-id="'.$record->id.'" data-status="'.$record->status.'" '.($record->status == 'Active' ? 'checked' : '').'></div>';
                })
                ->addColumn('Permissions', function ($record) {
                    $html = '';
                    /*if ($record->permission_id) {
                    $permissionsArray = json_decode($record->permission_id, true);
                    $permissionTypes = PermissionType::pluck('name', 'id')->toArray();

                    foreach ($permissionsArray as $permission) {
                        foreach ($permission as $module => $actions) {
                            $html .= '<span class="badge rounded-pill bg-success">' . $module . '</span> :- ';

                            foreach ($actions as $action) {
                                $actionName = $permissionTypes[$action] ?? "Unknown";
                                $html .= '<span class="badge rounded-pill bg-info me-2">' . $actionName . '</span>';
                            }

                            $html .= '<br>';
                        }
                    }
                    }*/
                    if ($record->permission_id) {
                        $permissionsArray = json_decode($record->permission_id, true);
                        $permissionTypes = PermissionType::pluck('name', 'id')->toArray();

                        $html = '<table class="">';
                        $html .= '<thead><tr><th>Sl No</th><th>Module</th><th>Actions</th></tr></thead>';
                        $html .= '<tbody>';

                        foreach ($permissionsArray as $key => $permission) {
                            foreach ($permission as $module => $actions) {
                                $html .= '<tr>';
                                $html .= '<td><span class="badge rounded-pill bg-dark">'.($key + 1).'</span></td>';
                                $html .= '<td><span class="badge rounded-pill bg-success">'.$module.'</span></td>';
                                $html .= '<td>';

                                foreach ($actions as $action) {
                                    $actionName = $permissionTypes[$action] ?? 'Unknown';
                                    $html .= '<span class="badge rounded-pill bg-info me-2">'.$actionName.'</span>';
                                }
                                // Remove trailing comma and space
                                $html = rtrim($html, ', ').'</td>';
                                $html .= '</tr>';
                            }
                        }

                        $html .= '</tbody></table>';
                    }

                    return $html;

                })
                ->editColumn('created_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->created_at));
                })
                ->editColumn('updated_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->updated_at));
                })
                ->addColumn('name', function ($record) {
                    return '<a type="button" class="text-primary" onclick="editmodal('.$record->id.')" 
                               data-bs-toggle="tooltip" 
                               title="Edit">
                               '.$record->name.'
                            </a>';
                })
                ->addColumn('action', function ($record) {
                    $html = '<div class="d-flex justify-content-center align-items-center gap-1">';
                    if (rolemanagement('Role', 3)) {
                        $html .= '<a type="button" onclick="editmodal('.$record->id.')" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fas fa-edit"></i></a> ';
                    }
                    if (rolemanagement('Role', 4)) {
                        if ($record->id != 1) {
                            $html .= '<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fas fa-trash"></i></button>';
                        }

                    }
                    $html .= '</div>';

                    return $html;
                })
                ->rawColumns(['name', 'status', 'sequence', 'action', 'Permissions'])
                ->make(true);
        }

        return view('admin.role.index', $this->data);

    }

    public function create()
    {
        if (! rolemanagement('Role', 2)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => true,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }

        return response()->json([
            'success' => true,
            'html' => view('admin.role.create')->render(),
        ]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'permission_id' => 'required',
        ]);

        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }

        $record = new Role;
        $record->name = $request->name;
        foreach ($request->modul_name as $key => $modul_name) {
            $array[] = [
                $modul_name => $request->permission_id[$key],
            ];
        }
        $record->permission_id = json_encode($array);
        $record->status = 'Active';
        $record->save();

        $response['success'] = true;
        $response['message'] = 'Create successfully';

        return response()->json($response);
    }

    public function edit(Request $request)
    {
        if (! rolemanagement('Role', 3)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => true,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }
        $record = Role::find($request->id);
        $permissionids = explode(',', $record->permission_id);
        $permissionsArray = json_decode($record->permission_id, true);
        $data = [
            'record' => $record,
            'permissionsArray' => $permissionsArray ?? [],
        ];

        return response()->json([
            'success' => true,
            'html' => view('admin.role.edit', $data)->render(),
        ]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:5120',
        ]);
        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }

        $record = Role::find($request->id);
        $record->name = $request->name;
        foreach ($request->modul_name as $key => $modul_name) {
            $array[] = [
                $modul_name => $request->permission_id[$key],
            ];
        }
        $record->permission_id = json_encode($array);
        $record->update();

        $response['success'] = true;
        $response['message'] = 'Update successfully';

        return response()->json($response);
    }

    public function sequence_update(Request $request)
    {
        $record = Role::find($request->id);
        if ($request->ajax()) {
            if (! empty($request->currentStatus)) {
                if ($request->currentStatus == 'Active') {
                    $record->status = 'Inactive';
                } else {
                    $record->status = 'Active';
                }
            }
            if (! empty($request->sequence)) {
                $record->sequence = $request->sequence;
            } else {
                $record->sequence = null;
            }
            $record->update();
            $response['success'] = true;
            $response['message'] = 'Update successfully';

            return response()->json($response);
        }
    }

    public function destroy(Request $request)
    {
        if (! rolemanagement('Role', 4)) {
            abort(401);
        }
        $record = Role::find($request->id);
        if ($record) {
            $record->delete();

            return response()->json([
                'success' => true,
                'message' => 'Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Role not found',
        ]);
    }
}
