<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\PermissionType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class PermissionTypeController extends Controller
{
    private $data = [
        'route' => 'admin.permission-type.',
        'title' => 'Permission Type',
        'menu' => 'PermissionType',
        'submenu' => '',
    ];

    public function index(Request $request)
    {
        if (! rolemanagement('Permission Type', 1)) {
            abort(401);
        }
        if ($request->ajax()) {
            $records = PermissionType::query();

            return datatables()->of($records)
                ->addIndexColumn()
                ->editColumn('created_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->created_at));
                })
                ->editColumn('updated_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->updated_at));
                })
                ->addColumn('action', function ($record) {
                    $html = '<div class="d-flex justify-content-center align-items-center gap-1">';
                    if (rolemanagement('Permission Type', 3)) {
                        $html .= '<a type="button" onclick="editmodal('.$record->id.')" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fas fa-edit"></i></a> ';
                    }
                    if (rolemanagement('Permission Type', 4)) {
                        $html .= '<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fas fa-trash"></i></button>';
                    }
                    $html .= '</div>';

                    return $html;
                })
                ->rawColumns(['status', 'sequence', 'action'])
                ->make(true);
        }

        return view('admin.permissiontype.index', $this->data);

    }

    public function create()
    {
        if (! rolemanagement('Permission Type', 2)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => true,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }

        return response()->json([
            'success' => true,
            'html' => view('admin.permissiontype.create')->render(),
        ]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }

        $record = new PermissionType;
        $record->name = $request->name;
        $record->save();

        $response['success'] = true;
        $response['message'] = 'Create successfully';

        return response()->json($response);
    }

    public function edit(Request $request)
    {
        if (! rolemanagement('Permission Type', 3)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => true,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }
        $record = PermissionType::find($request->id);
        $data = [
            'record' => $record,
        ];

        return response()->json([
            'success' => true,
            'html' => view('admin.permission.edit', $data)->render(),
        ]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
        ]);
        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }

        $record = PermissionType::find($request->id);
        $record->name = $request->name;
        $record->update();

        $response['success'] = true;
        $response['message'] = 'Update successfully';

        return response()->json($response);
    }

    public function sequence_update(Request $request)
    {
        $record = PermissionType::find($request->id);
        if ($request->ajax()) {
            if (! empty($request->currentStatus)) {
                if ($request->currentStatus == 'Active') {
                    $record->status = 'Inactive';
                } else {
                    $record->status = 'Active';
                }
            }
            $record->update();
            $response['success'] = true;
            $response['message'] = 'Update successfully';

            return response()->json($response);
        }
    }

    public function destroy(Request $request)
    {
        if (! rolemanagement('Permission Type', 4)) {
            abort(401);
        }
        $record = PermissionType::find($request->id);
        if ($record) {
            $record->delete();

            return response()->json([
                'success' => true,
                'message' => 'Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'PermissionType not found',
        ]);
    }
}
