<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use App\Models\PermissionType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class PermissionController extends Controller
{
    private $data = [
        'route' => 'admin.permission.',
        'title' => 'Permission',
        'menu' => 'Permission',
        'submenu' => '',
    ];

    public function index(Request $request)
    {
        if (! rolemanagement('Permission', 1)) {
            abort(401);
        }
        if ($request->ajax()) {
            $records = Permission::query()->orderBy('id', 'DESC');

            return datatables()->of($records)
                ->addIndexColumn()
                ->addColumn('permission_type', function ($record) {
                    $selectedTypes = explode(',', $record->permission_type_id);
                    $html = '';
                    foreach ($selectedTypes as $selectedType) {
                        $pr = PermissionType::where('id', $selectedType)->first();
                        $html .= '<span class="badge rounded-pill bg-info me-1">'.$pr->name.'</span>';
                    }

                    return $html;
                })
                ->addColumn('status', function ($record) {
                    return '<div class="form-check form-switch ">
                            <input class="form-check-input status-toggle" style="" id="statusToggle" type="checkbox" data-id="'.$record->id.'" data-status="'.$record->status.'" '.($record->status == 'Active' ? 'checked' : '').'></div><input type="hidden" value="'.$record->status.'">';
                })
                ->editColumn('created_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->created_at));
                })
                ->editColumn('updated_at', function ($record) {
                    return date('d-m-Y H:i A', strtotime($record->updated_at));
                })
                ->addColumn('name', function ($record) {
                    return '<a type="button" class="text-primary" onclick="editmodal('.$record->id.')" 
                               data-bs-toggle="tooltip" 
                               title="Edit">
                               '.$record->name.'
                            </a>';
                })
                ->addColumn('action', function ($record) {
                    $html = '<div class="d-flex justify-content-center align-items-center gap-1">';
                    if (rolemanagement('Permission', 3)) {
                        $html .= '<a type="button" onclick="editmodal('.$record->id.')" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fas fa-edit"></i></a> ';
                    }
                    if (rolemanagement('Permission', 4)) {
                        $html .= '<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fas fa-trash"></i></button>';
                    }
                    $html .= '</div>';

                    return $html;
                })
                ->rawColumns(['name', 'status', 'permission_type', 'action'])
                ->make(true);
        }

        return view('admin.permission.index', $this->data);

    }

    public function create()
    {
        if (! rolemanagement('Permission', 2)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => false,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }

        return response()->json([
            'success' => true,
            'html' => view('admin.permission.create')->render(),
        ]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'permission_type_id.*' => 'required',
        ]);

        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }

        $record = new Permission;
        $record->name = $request->name;
        $record->status = 'Active';
        $per_type = implode(',', $request->permission_type_id);
        $record->permission_type_id = $per_type;
        $record->save();

        $response['success'] = true;
        $response['message'] = 'Create successfully';

        return response()->json($response);
    }

    public function edit(Request $request)
    {
        if (! rolemanagement('Permission', 3)) {
            abort(401);
        }
        if (! auth('admin')->check()) {
            return response()->json([
                'success' => false,
                'code' => -1,
                'message' => 'Unauthorized',
            ]);
        }
        $record = Permission::find($request->id);

        $data = [
            'record' => $record,

        ];

        return response()->json([
            'success' => true,
            'html' => view('admin.permission.edit', $data)->render(),
        ]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
        ]);
        if ($validator->fails()) {
            $response['success'] = false;
            $response['message'] = $validator->errors();

            return response()->json($response);
        }

        $record = Permission::find($request->id);
        $record->name = $request->name;
        $per_type = implode(',', $request->permission_type_id);
        $record->permission_type_id = $per_type;
        $record->update();

        $response['success'] = true;
        $response['message'] = 'Update successfully';

        return response()->json($response);
    }

    public function sequence_update(Request $request)
    {
        $record = Permission::find($request->id);
        if ($request->ajax()) {
            if (! empty($request->currentStatus)) {
                if ($request->currentStatus == 'Active') {
                    $record->status = 'Inactive';
                } else {
                    $record->status = 'Active';
                }
            }
            $record->update();
            $response['success'] = true;
            $response['message'] = 'Update successfully';

            return response()->json($response);
        }
    }

    public function destroy(Request $request)
    {
        if (! rolemanagement('Permission', 4)) {
            abort(401);
        }
        $record = Permission::find($request->id);
        if ($record) {
            $record->delete();

            return response()->json([
                'success' => true,
                'message' => 'Deleted successfully',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Permission not found',
        ]);
    }
}
