<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;
use RuntimeException;
use Str;
use Validator;

class LoginRegisterController extends Controller
{
    public $data = [];

    public function __construct()
    {
        // $this->middleware('guest:admin')->except([
        //     'logout', 'dashboard'
        // ]);
    }

    public function login()
    {
        $this->data['title'] = 'Login';
        if (Auth::guard('admin')->check()) {
            return redirect()->intended(route('admin.dashboard'));
        }

        // Admin::create([
        //     'name' => 'Developer',
        //     'email' => 'dev@admin.com',
        //     'password' => bcrypt('123456'),
        //     'mobile' => '1234567890',
        //     'status' => 'Active',
        // ]);

        return view('admin.login', $this->data);
    }

    public function authenticate(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), $this->getRules('Add', $request->all()), $this->messages());
            if ($validator->fails()) {
                return redirect()->back()->withInput()->withErrors($validator->messages());
            }
            $loginField = filter_var($request->email, FILTER_VALIDATE_EMAIL) ? 'email' : 'mobile';
            $user = Admin::where($loginField, $request->email)->first();
            if (! $user) {
                return redirect()->back()->withInput()->withErrors(['This email/mobile is not registered.']);
            }
            $credentials = [
                $loginField => $request->email,
                'password' => $request->password,
            ];
            if (Auth::guard('admin')->attempt($credentials, $request->get('remember'))) {
                $user = Auth::guard('admin')->user();
                if ($user->status !== 'Active') {
                    Auth::guard('admin')->logout();

                    return redirect()->back()->withInput()->withErrors(['Your account is inactive. Please contact support.']);
                }

                return redirect()->route('admin.dashboard')->withSuccess('You have successfully logged in!');
            }

            return redirect()->back()->withInput()->withErrors(['Incorrect password. Please try again.']);
        } catch (RuntimeException $ex) {
            return redirect()->back()->withInput()->withErrors([$ex->getMessage()]);
        }

    }

    private function getRules($type, $input)
    {
        $return = [];
        $return['email'] = 'required|max:50';

        // $return['password'] = 'required|max:20';
        return $return;

    }

    private function messages()
    {
        return [
            // 'question.required'  => 'The question field is required.'
        ];
    }

    public function logout(Request $request)
    {

        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('admin.login')->withSuccess('You have logged out successfully!');
    }

    public function pass_email()
    {
        return view('admin.password.email');
    }

    public function sendResetLink(Request $request)
    {
        $request->validate(['email' => 'required|email']);
        $status = Password::broker('admins')->sendResetLink($request->only('email'));

        if ($status == Password::RESET_LINK_SENT) {
            return back()->with(['status' => __($status)]);
        }

        return back()->withErrors(['email' => __($status)]);
    }

    public function showResetForm($token)
    {
        return view('admin.password.reset', ['token' => $token]);
    }

    public function reset(Request $request)
    {
        $request->validate([
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:6|max:20',
        ]);

        $status = Password::broker('admins')->reset(
            $request->only('email', 'password', 'password_confirmation', 'token'),
            function ($user, $password) {
                $user->forceFill([
                    'password' => Hash::make($password),
                    'show_password' => $password,
                ])->setRememberToken(Str::random(60));

                $user->save();

                event(new PasswordReset($user));
            }
        );

        if ($status == Password::PASSWORD_RESET) {
            return redirect()->route('admin.login')->withSuccess('Password Update successfully');
        }

        return back()->withErrors(['email' => [__($status)]]);
    }
}
