<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use Auth;
use File;
use Hash;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    private $data = [
        'title' => 'Admin Dashboard',
    ];

    public function dashboard(Request $request)
    {

        return view('admin.dashboard', $this->data);
    }

    public function profile_edit()
    {
        return view('admin.profile_edit');
    }

    public function profile_update(Request $request)
    {
        $admin = Admin::where('id', Auth::guard('admin')->user()->id)->first();

        $admin->name = $request->name;
        $admin->email = $request->email;
        if ($request->password) {
            $admin->password = Hash::make($request->password);
            $admin->show_password = $request->password;
        }

        if ($request->hasFile('profile_image')) {

            if (File::exists(asset($admin->profile_image))) {
                File::delete(asset($admin->profile_image));
            }
            $image = rand().time().'.'.$request->profile_image->extension();
            $request->profile_image->move(public_path('uploads/employee'), $image);
            $admin->profile_image = 'uploads/employee/'.$image;

        }

        $admin->update();

        return redirect()->back()->with('success', 'Profile updated successfully');
    }

    public function setting()
    {
        $record['title'] = 'Setting';

        return view('admin.setting', $record);
    }
}
