<?php

use App\Models\Role;
use Illuminate\Support\Facades\Auth;

function rolemanagement($module, $permissionId)
{

    $auth = Auth::guard('admin')->user();
    if (! Auth::guard('admin')->check()) {
        return redirect()->route('admin.login');
    }

    if ($auth->role_id == 1) {
        return true;
    }

    $rolemanagement = Cache::remember('role_'.$auth->role_id, 3600, function () use ($auth) {
        return Role::where('id', $auth->role_id)->first();
    });

    $permissionsArray = json_decode($rolemanagement->permission_id, true);
    foreach ($permissionsArray as $permission) {
        if (array_key_exists($module, $permission)) {
            return in_array($permissionId, $permission[$module]);
        }
    }

    return false;
}

function secendConvertMin($secend)
{
    $secend = is_numeric($secend) ? (int) $secend : 0;

    return sprintf('%02d:%02d:%02d', floor($secend / 3600), floor(($secend % 3600) / 60), $secend % 60);
}

function secendConvertMin2($secend)
{
    if ($secend == 0) {
        return null;
    }

    return sprintf('%02d:%02d:%02d', floor($secend / 3600), floor(($secend % 3600) / 60), $secend % 60);
}
function secendConvertMin3($secend)
{
    if (! is_numeric($secend) || $secend <= 0) {
        return null;
    }

    return sprintf('%02d:%02d:%02d', floor($secend / 3600), floor(($secend % 3600) / 60), $secend % 60);
}
function restrictByAuthor($query)
{
    $user = Auth::guard('admin')->user();
    if ($user && $user->role_id != 1) {
        $table = $query->getModel()->getTable();
        $query->where($table.'.author_id', $user->id);
    }

    return $query;
}

function getResignData($query)
{
    $user = Auth::guard('admin')->user();
    if ($user && $user->role_id != 1) {
        $table = $query->getModel()->getTable();
        $query->where($table.'.admin_id', $user->id);
    }

    return $query;
}

// Helper method to convert number to words (Indian format)
function numberToWords($number)
{
    $ones = [
        0 => 'zero', 1 => 'one', 2 => 'two', 3 => 'three', 4 => 'four', 5 => 'five',
        6 => 'six', 7 => 'seven', 8 => 'eight', 9 => 'nine', 10 => 'ten',
        11 => 'eleven', 12 => 'twelve', 13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
        16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen', 19 => 'nineteen',
    ];

    $tens = [
        0 => '', 2 => 'twenty', 3 => 'thirty', 4 => 'forty', 5 => 'fifty',
        6 => 'sixty', 7 => 'seventy', 8 => 'eighty', 9 => 'ninety',
    ];

    // Convert float to string to handle decimals
    $number = number_format((float) $number, 2, '.', '');
    [$integerPart, $decimalPart] = explode('.', $number);

    // Convert integer part
    $words = convertNumberToWords((int) $integerPart, $ones, $tens);

    // Convert decimal part if not 00
    if ((int) $decimalPart > 0) {
        $words .= ' and '.convertNumberToWords((int) $decimalPart, $ones, $tens).' paisa';
    }

    return $words;
}

function convertNumberToWords($number, $ones, $tens)
{
    if ($number < 20) {
        return $ones[$number];
    } elseif ($number < 100) {
        return $tens[intval($number / 10)].(($number % 10 != 0) ? ' '.$ones[$number % 10] : '');
    } elseif ($number < 1000) {
        return $ones[intval($number / 100)].' hundred'.(($number % 100 != 0) ? ' '.convertNumberToWords($number % 100, $ones, $tens) : '');
    } elseif ($number < 100000) {
        return convertNumberToWords(intval($number / 1000), $ones, $tens).' thousand'.(($number % 1000 != 0) ? ' '.convertNumberToWords($number % 1000, $ones, $tens) : '');
    } elseif ($number < 10000000) {
        return convertNumberToWords(intval($number / 100000), $ones, $tens).' lakh'.(($number % 100000 != 0) ? ' '.convertNumberToWords($number % 100000, $ones, $tens) : '');
    } else {
        return convertNumberToWords(intval($number / 10000000), $ones, $tens).' crore'.(($number % 10000000 != 0) ? ' '.convertNumberToWords($number % 10000000, $ones, $tens) : '');
    }
}
function ceilMinutesFromHms(?string $hms): int
{
    if (! $hms) {
        return 0;
    }
    if (! preg_match('/^\s*(\d+):([0-5]?\d):([0-5]?\d)\s*$/', $hms, $m)) {
        throw new InvalidArgumentException('timeSpent must be HH:MM:SS');
    }

    return (int) ceil(($m[1] * 3600 + $m[2] * 60 + $m[3]) / 60);
}
function ceilMinutesFromDuration(?string $duration): int
{
    if (! $duration || strtoupper($duration) === 'NULL') {
        return 0;
    }
    /* If it's already numeric (like "15", "22", "52") */
    if (is_numeric($duration)) {
        return (int) ceil($duration);
    }
    /* If it's HH:MM:SS */
    if (preg_match('/^(\d+):([0-5]?\d):([0-5]?\d)$/', $duration, $m)) {
        $seconds = $m[1] * 3600 + $m[2] * 60 + $m[3];

        return (int) ceil($seconds / 60);
    }

    /* If format unexpected → return 0 */
    return 0;
}
function handleVoiceTokenAndSync(): void
{
    try {
        $tokenResp = app()->call('App\\Http\\Controllers\\Controller@generatebonovoicetoken');
        $tokenData = is_array($tokenResp) ? $tokenResp : $tokenResp->getData(true);

        if (! empty($tokenData['token'])) {
            app()->call('App\\Http\\Controllers\\Controller@syncVoicePrompts', ['force' => true]);
        } else {
            Log::error('voicecalllist-error Token generation failed: '.json_encode($tokenData));
        }
    } catch (\Throwable $e) {
        Log::error('voicecalllist-error Exception: '.$e->getMessage(), [
            'trace' => $e->getTraceAsString(),
        ]);
    }
}

function sql_date($date)
{

    return $date ? date('Y-m-d', strtotime($date)) : null;
}

function _d($date)
{
    return $date ? date('d-m-Y', strtotime($date)) : null;
}
