<?php
namespace App\Exports;

use App\Models\Admin;
use App\Models\City;
use App\Models\Language;
use App\Models\CampaignDetail;
use App\Models\WorkingHour;
use App\Models\Product;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;

class TelecallerReportExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;
    protected $id;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $query = Admin::where('product_by', 1);
        return $query->get();
    }

    public function headings(): array
    {
        return ['Created At','Name','Number','City','Working Hours','Status','Target Working Hours','Success Lead','Success Lead Rs','Rate','Create Payment Amount','Payment Date','Language','Progress','Last Login'];
    }

    public function map($value): array
    {
        $working_hours = WorkingHour::where('user_id',$value->id)->where('created_at', '>=', date('Y-m-d',strtotime($this->request->start_date)))->where('created_at', '<=', date('Y-m-d',strtotime($this->request->end_date)))->sum('total_hours');
        $city_name =  City::whereIn('id',explode(',', $value->city))->pluck('name')->implode(', ');
        $language = Language::whereIn('id',explode(',', $value->language))->pluck('name')->implode(', ');
        $logged_in_today = WorkingHour::where('user_id', $value->id)
                                        ->where('created_at', '>=', date('Y-m-d',strtotime($this->request->start_date)))->where('created_at', '<=', date('Y-m-d',strtotime($this->request->end_date)))
                                        ->exists();
        $daily_working_hours = WorkingHour::where('user_id', $value->id)
                                        ->where('created_at', '>=', date('Y-m-d',strtotime($this->request->start_date)))->where('created_at', '<=', date('Y-m-d',strtotime($this->request->end_date)))
                                        ->sum('total_hours');
        $daily_success_lead = CampaignDetail::where('staff_id', $value->id)
                                            ->where('status', 'Interested')
                                            ->where('call_date', '>=', date('Y-m-d',strtotime($this->request->start_date)))->where('call_date', '<=', date('Y-m-d',strtotime($this->request->end_date)))
                                            ->count();
                if (!$logged_in_today) {
                    $progress = 'Bed';
                } elseif ($daily_success_lead >= 5 && $daily_working_hours >= 4) {
                    $progress = 'Very Good';
                } elseif ($daily_working_hours >= 3) {
                    $progress = 'Good';
                } else {
                    $progress = 'Slow';
                }   
        $last_login = WorkingHour::where('user_id',$value->id)->orderBy('id','desc')->first();
        $success_lead_rs = CampaignDetail::where('staff_id',$value->id)->where('status','Interested')->where('call_date', '>=', date('Y-m-d',strtotime($this->request->start_date)))->where('call_date', '<=', date('Y-m-d',strtotime($this->request->end_date)))->sum('lead_earn');
        $working_lead_rs = CampaignDetail::where('staff_id',$value->id)->where('call_date', '>=', date('Y-m-d',strtotime($this->request->start_date)))->where('call_date', '<=', date('Y-m-d',strtotime($this->request->end_date)))->sum('working_earn');
        $create_payment_amount = $success_lead_rs + $working_lead_rs;
        return [
                $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
                $value->name??'-',
                $value->mobile??'-',
                $city_name??'-',
                secendConvertMin($working_hours),
                $value->status??'-',
                $value->working_hours??'-',
                $daily_success_lead??'-',
                $value->lead_complet_bounce??'-',
                $value->minute_rate??'-',
                $create_payment_amount??'-',
                $value->payment_date?date('d-m-Y', strtotime($value->payment_date)):'-',
                $language??'-',
                $progress??'-',
                $last_login?date('d-m-Y H:i A', strtotime($last_login->start_time)):'-',
        ];
    }
}