<?php
namespace App\Exports;

use App\Models\Admin;
use App\Models\City;
use App\Models\Language;
use App\Models\CampaignDetail;
use App\Models\WorkingHour;
use App\Models\Campaign;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;

class TelecallerHRReportExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $cities = Campaign::where('product_id',1)->where('status','Active')->orWhere('status','On Hold')->pluck('city')->unique()->implode(',');
        $records = City::whereIn('id',explode(',', $cities));
        return $records->get();
    }

    public function headings(): array
    {
        return ['City','Campaign','Language','Camping Time For Cast','Calling Closed','Telecaller Active','Telecaller Deactive','Total Telecaller','Live Telecaller','Today Working Time','Total Campaign Calling Time In Days','Finished Calling In Days','Pending Calling In Days','Required Telecaller','Required Houres'];
    }

    public function map($value): array
    {
        $request = $this->request;
        $campaign = Campaign::whereRaw("FIND_IN_SET(?, city)", [$value->id])
                                    ->where('created_at', '>=', date('Y-m-d',strtotime($request->start_date)))
                                    ->where('created_at', '<=', date('Y-m-d',strtotime($request->end_date)))
                                    ->count();
        $language = Campaign::whereRaw("FIND_IN_SET(?, city)", [$value->id])
                ->where('created_at', '>=', date('Y-m-d',strtotime($request->start_date)))
                ->where('created_at', '<=', date('Y-m-d',strtotime($request->end_date)))
                ->pluck('language')->unique()->implode(',');
        $language_name = Language::whereIn('id',explode(',', $language))->pluck('name')->implode(', ');
        $camping_time_for_cast = Campaign::whereRaw("FIND_IN_SET(?, city)", [$value->id])
                                ->where('created_at', '>=', date('Y-m-d',strtotime($request->start_date)))
                                ->where('created_at', '<=', date('Y-m-d',strtotime($request->end_date)))
                                ->sum('camping_time_for_cast');
        $totalMinutes = CampaignDetail::whereRaw("FIND_IN_SET(?, database_city_id)", [$value->id])
                                ->where('created_at', '>=', date('Y-m-d',strtotime($request->start_date)))
                                ->where('created_at', '<=', date('Y-m-d',strtotime($request->end_date)))
                                ->selectRaw('ROUND(SUM(TIME_TO_SEC(timeSpent)) / 60, 2) as total_minutes')
                                ->value('total_minutes');
        $telecaller_active = Admin::where('city', $value->id)->where('status','Active')->count();
        $telecaller_deactive = Admin::where('city', $value->id)->where('status','Inactive')->count();
        $total_telecaller = Admin::where('city', $value->id)->count();
        $activeTelecallers = WorkingHour::whereIn('user_id', function ($query) use ($value) {
            $query->select('id')->from('admins')->where('city', $value->id);
        })
        ->whereDate('created_at',date('Y-m-d'))
        ->distinct('user_id')
        ->count('user_id');
        
        $today_working_time = CampaignDetail::whereRaw("FIND_IN_SET(?, database_city_id)", [$value->id])
                    ->selectRaw('SUM(TIME_TO_SEC(timeSpent)) as total_seconds')
                    ->whereDate('call_date',date('Y-m-d'))
                    ->value('total_seconds');

        $totalminutes = CampaignDetail::whereRaw("FIND_IN_SET(?, database_city_id)", [$value->id])->sum('per_user_call_time');
        $total_campaign_calling_time_in_days = round($totalminutes / 600, 1);

        $totalSeconds = CampaignDetail::whereRaw("FIND_IN_SET(?, database_city_id)", [$value->id])
                                    ->selectRaw('SUM(TIME_TO_SEC(timeSpent)) as total_seconds')
                                    ->value('total_seconds');
        $days = $totalSeconds / 36000;
        $finished_calling_in_days = round($days, 1);

        $pending_calling_in_days = round($total_campaign_calling_time_in_days - $finished_calling_in_days, 1);

        if($activeTelecallers == 0){
            $required_telecaller = $pending_calling_in_days;
        }else{
            $required_telecaller = $pending_calling_in_days / $activeTelecallers;
        }
        return [
                $value->name,
                $campaign??'-',
                $language_name??'-',
                $camping_time_for_cast??'-',
                $totalMinutes??'-',
                $telecaller_active??'-',
                $telecaller_deactive??'-',
                $total_telecaller??'-',
                $activeTelecallers??'-',
                secendConvertMin($today_working_time),
                $total_campaign_calling_time_in_days??'-',
                $finished_calling_in_days??'-',
                $pending_calling_in_days??'-',
                round($required_telecaller,1),
                round($required_telecaller * 10,1),
            ];
    }
}