<?php
namespace App\Exports;

use App\Models\ReturnInvoice;
use App\Models\Member;
use App\Models\Category;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;
use Illuminate\Support\Facades\Auth;
class ReturnPaymentExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $request = $this->request;
        $records = ReturnInvoice::query();
        if($request->member_id){
            $records->where('member_id', $request->member_id);
        }
        if($request->startDate){
            $records->where('created_at', '>=', $request->startDate);
        }
        if($request->endDate){
            $records->where('created_at', '<=', $request->endDate);
        }
        return $records->get();
    }

    public function headings(): array
    {
        return ['Member Name','Business Name','Mobile No','City','Email','Category','Date&time','Amount','Description','Created At','Updated At'];
    }

    public function map($value): array
    {
        return [
                $value->member->name??'-' ,
                $value->member->businessName??'-',
                $value->member->mobile??'-',
                $value->member->city->name??'-',
                $value->member->email??'-',
                Category::whereIn('id',explode(',', $value->member->category_id))->pluck('name')->implode(', ')??'-' ,
                $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
                $value->amount??'-',
                $value->description??'-',
                $value->created_at?date('d-m-Y', strtotime($value->created_at)):'-',
                $value->updated_at?date('d-m-Y', strtotime($value->updated_at)):'-',
        ];
    }
}