<?php
namespace App\Exports;

use App\Models\Expense;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithMapping;

class ExpenseExport implements FromCollection, WithHeadings, ShouldAutoSize, WithMapping
{
    protected $request;

    public function __construct($request)
    {
        $this->request = $request;
    }

    public function collection()
    {
        $request = $this->request;
        $records = Expense::orderBy('id', 'desc');
		$records = restrictByAuthor($records);
            if($request->expense_type){
                $records->where('expense_type', $request->expense_type);
            }
            if($request->startDate){
                $records->whereDate('date', '>=', date('Y-m-d', strtotime($request->startDate)));
            }
            if($request->endDate){
                $records->whereDate('date', '<=', date('Y-m-d', strtotime($request->endDate)));
            }
        return $records->get();
    }

    public function headings(): array
    {
        return ['Beneficiary Name','Bank Name','IFSC Code','Account Number','Payment Type','UTR Number',
		'Date','Amount','Expense Type','Description','Status','Created At'];
    }

    public function map($value): array
    {
        $request = $this->request;
        return [
			$value->name,
			$value->bank,
			$value->ifsc,
			$value->acc_no,
			$value->payment_type,
			$value->payout_transaction_ref_no,
			date('d-m-Y', strtotime($value->date)),
			$value->amount,
			$value->expense_type,
			$value->description,
			$value->payout_status,
            date('d-m-Y H:i A', strtotime($value->created_at)),
        ];
    }
}